/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.flink.FlinkRowData;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.types.RowKind;

public class FlinkRowWrapper
implements InternalRow {
    private final RowData row;

    public FlinkRowWrapper(RowData row) {
        this.row = row;
    }

    @Override
    public int getFieldCount() {
        return this.row.getArity();
    }

    @Override
    public RowKind getRowKind() {
        return FlinkRowWrapper.fromFlinkRowKind(this.row.getRowKind());
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.row.setRowKind(FlinkRowData.toFlinkRowKind(kind));
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.row.isNullAt(pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.row.getBoolean(pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.row.getByte(pos);
    }

    @Override
    public short getShort(int pos) {
        return this.row.getShort(pos);
    }

    @Override
    public int getInt(int pos) {
        return this.row.getInt(pos);
    }

    @Override
    public long getLong(int pos) {
        return this.row.getLong(pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.row.getFloat(pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.row.getDouble(pos);
    }

    @Override
    public BinaryString getString(int pos) {
        return FlinkRowWrapper.fromFlinkString(this.row.getString(pos));
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return FlinkRowWrapper.fromFlinkDecimal(this.row.getDecimal(pos, precision, scale));
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return FlinkRowWrapper.fromFlinkTimestamp(this.row.getTimestamp(pos, precision));
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.row.getBinary(pos);
    }

    @Override
    public Variant getVariant(int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalArray getArray(int pos) {
        return new FlinkArrayWrapper(this.row.getArray(pos));
    }

    @Override
    public InternalMap getMap(int pos) {
        return new FlinkMapWrapper(this.row.getMap(pos));
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return new FlinkRowWrapper(this.row.getRow(pos, numFields));
    }

    public static BinaryString fromFlinkString(StringData str) {
        return BinaryString.fromBytes(str.toBytes());
    }

    public static Timestamp fromFlinkTimestamp(TimestampData timestamp) {
        return Timestamp.fromEpochMillis(timestamp.getMillisecond(), timestamp.getNanoOfMillisecond());
    }

    public static Decimal fromFlinkDecimal(DecimalData decimal) {
        if (decimal.isCompact()) {
            return Decimal.fromUnscaledLong(decimal.toUnscaledLong(), decimal.precision(), decimal.scale());
        }
        return Decimal.fromBigDecimal(decimal.toBigDecimal(), decimal.precision(), decimal.scale());
    }

    public static RowKind fromFlinkRowKind(org.apache.flink.types.RowKind rowKind) {
        switch (rowKind) {
            case INSERT: {
                return RowKind.INSERT;
            }
            case UPDATE_BEFORE: {
                return RowKind.UPDATE_BEFORE;
            }
            case UPDATE_AFTER: {
                return RowKind.UPDATE_AFTER;
            }
            case DELETE: {
                return RowKind.DELETE;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Object fromFlinkObject(Object o, LogicalType type) {
        if (o == null) {
            return null;
        }
        return InternalRow.createFieldGetter(LogicalTypeConversion.toDataType(type), 0).getFieldOrNull(new FlinkRowWrapper((RowData)GenericRowData.of((Object[])new Object[]{o})));
    }

    private static class FlinkMapWrapper
    implements InternalMap {
        private final MapData map;

        private FlinkMapWrapper(MapData map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public InternalArray keyArray() {
            return new FlinkArrayWrapper(this.map.keyArray());
        }

        @Override
        public InternalArray valueArray() {
            return new FlinkArrayWrapper(this.map.valueArray());
        }
    }

    private static class FlinkArrayWrapper
    implements InternalArray {
        private final ArrayData array;

        private FlinkArrayWrapper(ArrayData array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.size();
        }

        @Override
        public boolean isNullAt(int pos) {
            return this.array.isNullAt(pos);
        }

        @Override
        public boolean getBoolean(int pos) {
            return this.array.getBoolean(pos);
        }

        @Override
        public byte getByte(int pos) {
            return this.array.getByte(pos);
        }

        @Override
        public short getShort(int pos) {
            return this.array.getShort(pos);
        }

        @Override
        public int getInt(int pos) {
            return this.array.getInt(pos);
        }

        @Override
        public long getLong(int pos) {
            return this.array.getLong(pos);
        }

        @Override
        public float getFloat(int pos) {
            return this.array.getFloat(pos);
        }

        @Override
        public double getDouble(int pos) {
            return this.array.getDouble(pos);
        }

        @Override
        public BinaryString getString(int pos) {
            return FlinkRowWrapper.fromFlinkString(this.array.getString(pos));
        }

        @Override
        public Decimal getDecimal(int pos, int precision, int scale) {
            return FlinkRowWrapper.fromFlinkDecimal(this.array.getDecimal(pos, precision, scale));
        }

        @Override
        public Timestamp getTimestamp(int pos, int precision) {
            return FlinkRowWrapper.fromFlinkTimestamp(this.array.getTimestamp(pos, precision));
        }

        @Override
        public byte[] getBinary(int pos) {
            return this.array.getBinary(pos);
        }

        @Override
        public Variant getVariant(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalArray getArray(int pos) {
            return new FlinkArrayWrapper(this.array.getArray(pos));
        }

        @Override
        public InternalMap getMap(int pos) {
            return new FlinkMapWrapper(this.array.getMap(pos));
        }

        @Override
        public InternalRow getRow(int pos, int numFields) {
            return new FlinkRowWrapper(this.array.getRow(pos, numFields));
        }

        @Override
        public boolean[] toBooleanArray() {
            return this.array.toBooleanArray();
        }

        @Override
        public byte[] toByteArray() {
            return this.array.toByteArray();
        }

        @Override
        public short[] toShortArray() {
            return this.array.toShortArray();
        }

        @Override
        public int[] toIntArray() {
            return this.array.toIntArray();
        }

        @Override
        public long[] toLongArray() {
            return this.array.toLongArray();
        }

        @Override
        public float[] toFloatArray() {
            return this.array.toFloatArray();
        }

        @Override
        public double[] toDoubleArray() {
            return this.array.toDoubleArray();
        }
    }
}

