/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.StringUtils;

public class ClearConsumerAction
extends TableActionBase {
    private String includingConsumers;
    private String excludingConsumers;

    protected ClearConsumerAction(String databaseName, String tableName, Map<String, String> catalogConfig) {
        super(databaseName, tableName, catalogConfig);
    }

    public ClearConsumerAction withIncludingConsumers(@Nullable String includingConsumers) {
        this.includingConsumers = includingConsumers;
        return this;
    }

    public ClearConsumerAction withExcludingConsumers(@Nullable String excludingConsumers) {
        this.excludingConsumers = excludingConsumers;
        return this;
    }

    @Override
    public void run() throws Exception {
        FileStoreTable dataTable = (FileStoreTable)this.table;
        ConsumerManager consumerManager = new ConsumerManager(dataTable.fileIO(), dataTable.location(), dataTable.snapshotManager().branch());
        Pattern includingPattern = StringUtils.isNullOrWhitespaceOnly(this.includingConsumers) ? Pattern.compile(".*") : Pattern.compile(this.includingConsumers);
        Pattern excludingPattern = StringUtils.isNullOrWhitespaceOnly(this.excludingConsumers) ? null : Pattern.compile(this.excludingConsumers);
        consumerManager.clearConsumers(includingPattern, excludingPattern);
    }
}

