/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.operation.MergeFileSplitRead;
import org.apache.paimon.reader.EmptyRecordReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.splitread.IncrementalDiffSplitRead;

public class IncrementalCompactDiffSplitRead
extends IncrementalDiffSplitRead {
    public IncrementalCompactDiffSplitRead(MergeFileSplitRead mergeRead) {
        super(mergeRead);
    }

    @Override
    public RecordReader<InternalRow> createReader(DataSplit split) throws IOException {
        if (split.beforeFiles().stream().noneMatch(file -> file.level() == 0)) {
            return new EmptyRecordReader<InternalRow>();
        }
        return super.createReader(this.filterLevel0Files(split));
    }

    private DataSplit filterLevel0Files(DataSplit split) {
        List<DataFileMeta> beforeFiles = split.beforeFiles().stream().filter(file -> file.level() > 0).collect(Collectors.toList());
        List<DataFileMeta> afterFiles = split.dataFiles().stream().filter(file -> file.level() > 0).collect(Collectors.toList());
        DataSplit.Builder builder = new DataSplit.Builder().withSnapshot(split.snapshotId()).withPartition(split.partition()).withBucket(split.bucket()).withBucketPath(split.bucketPath()).withBeforeFiles(beforeFiles).withDataFiles(afterFiles).isStreaming(split.isStreaming()).rawConvertible(split.rawConvertible());
        if (split.beforeDeletionFiles().isPresent()) {
            builder.withBeforeDeletionFiles(split.beforeDeletionFiles().get());
        }
        if (split.deletionFiles().isPresent()) {
            builder.withDataDeletionFiles(split.deletionFiles().get());
        }
        return builder.build();
    }
}

