/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.flink.lookup.PartitionLoader;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowPartitionComputer;

public class StaticPartitionLoader
extends PartitionLoader {
    private final List<Map<String, String>> scanPartitions;

    protected StaticPartitionLoader(FileStoreTable table, List<Map<String, String>> scanPartitions) {
        super(table);
        this.scanPartitions = scanPartitions;
    }

    @Override
    public void open() {
        this.partitions = new ArrayList();
        RowType partitionType = this.table.schema().logicalPartitionType();
        InternalRowSerializer serializer = new InternalRowSerializer(partitionType);
        for (Map<String, String> spec : this.scanPartitions) {
            GenericRow row = InternalRowPartitionComputer.convertSpecToInternalRow(spec, partitionType, this.table.coreOptions().partitionDefaultName());
            this.partitions.add(serializer.toBinaryRow(row).copy());
        }
    }

    @Override
    public boolean checkRefresh() {
        return false;
    }
}

