/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;

public class DeleteBranchProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "delete_branch";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="branch", type=@DataTypeHint(value="STRING"))})
    public String[] call(ProcedureContext procedureContext, String tableId, String branchStr) throws Catalog.TableNotExistException {
        Identifier identifier = Identifier.fromString(tableId);
        this.catalog.getTable(identifier).deleteBranches(branchStr);
        this.catalog.invalidateTable(new Identifier(identifier.getDatabaseName(), identifier.getTableName(), branchStr));
        return new String[]{"Success"};
    }
}

