/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.paimon.data.InternalRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.ChannelComputer;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;
import org.apache.paimon.table.sink.UnawareBucketRowKeyExtractor;

public class RowDataHashPartitionChannelComputer
implements ChannelComputer<InternalRow> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private transient int numChannels;
    private transient KeyAndBucketExtractor<InternalRow> extractor;

    public RowDataHashPartitionChannelComputer(TableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.extractor = new UnawareBucketRowKeyExtractor(this.schema);
    }

    @Override
    public int channel(InternalRow record) {
        this.extractor.setRecord(record);
        return ChannelComputer.select(this.extractor.partition(), 0, this.numChannels);
    }

    public String toString() {
        return "shuffle by partition";
    }
}

