/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.assigners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.assigners.SplitAssigner;
import org.apache.paimon.flink.utils.TableScanUtils;

public class FIFOSplitAssigner
implements SplitAssigner {
    private final LinkedList<FileStoreSourceSplit> pendingSplitAssignment;

    public FIFOSplitAssigner(Collection<FileStoreSourceSplit> splits) {
        this.pendingSplitAssignment = new LinkedList<FileStoreSourceSplit>(splits);
    }

    @Override
    public List<FileStoreSourceSplit> getNext(int subtask, @Nullable String hostname) {
        FileStoreSourceSplit split = this.pendingSplitAssignment.poll();
        return split == null ? Collections.emptyList() : Collections.singletonList(split);
    }

    @Override
    public void addSplit(int suggestedTask, FileStoreSourceSplit split) {
        this.pendingSplitAssignment.add(split);
    }

    @Override
    public void addSplitsBack(int subtask, List<FileStoreSourceSplit> splits) {
        ListIterator<FileStoreSourceSplit> iterator2 = splits.listIterator(splits.size());
        while (iterator2.hasPrevious()) {
            this.pendingSplitAssignment.addFirst(iterator2.previous());
        }
    }

    @Override
    public Collection<FileStoreSourceSplit> remainingSplits() {
        return new ArrayList<FileStoreSourceSplit>(this.pendingSplitAssignment);
    }

    @Override
    public Optional<Long> getNextSnapshotId(int subtask) {
        return this.pendingSplitAssignment.isEmpty() ? Optional.empty() : TableScanUtils.getSnapshotId(this.pendingSplitAssignment.peekFirst());
    }

    @Override
    public int numberOfRemainingSplits() {
        return this.pendingSplitAssignment.size();
    }
}

