/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.flink.action.ResetConsumerAction;

public class ResetConsumerActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "reset_consumer";
    private static final String CONSUMER_ID = "consumer_id";
    private static final String NEXT_SNAPSHOT = "next_snapshot";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        ResetConsumerAction action = new ResetConsumerAction(params.getRequired("database"), params.getRequired("table"), this.catalogConfigMap(params), params.getRequired(CONSUMER_ID));
        if (params.has(NEXT_SNAPSHOT)) {
            action.withNextSnapshotIds(Long.parseLong(params.get(NEXT_SNAPSHOT)));
        }
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"reset_consumer\" reset a consumer with a given consumer ID and next snapshot ID and delete a consumer with a given consumer ID.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  reset_consumer \\\n--warehouse <warehouse_path> \\\n--database <database_name> \\\n--table <table_name> \\\n--consumer_id <consumer_id> \\\n[--next_snapshot <next_snapshot_id>]");
        System.out.println();
        System.out.println("Note:");
        System.out.println("  please don't specify --next_snapshot parameter if you want to delete the consumer.");
        System.out.println();
    }
}

