/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Locale;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.orphan.FlinkOrphanFilesClean;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.operation.CleanOrphanFilesResult;
import org.apache.paimon.operation.LocalOrphanFilesClean;
import org.apache.paimon.operation.OrphanFilesClean;

public class RemoveOrphanFilesProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "remove_orphan_files";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="older_than", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="dry_run", type=@DataTypeHint(value="BOOLEAN"), isOptional=true), @ArgumentHint(name="parallelism", type=@DataTypeHint(value="INT"), isOptional=true), @ArgumentHint(name="mode", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, String olderThan, Boolean dryRun, Integer parallelism, String mode) throws Exception {
        Identifier identifier = Identifier.fromString(tableId);
        String databaseName = identifier.getDatabaseName();
        String tableName = identifier.getObjectName();
        if (mode == null) {
            mode = "DISTRIBUTED";
        }
        try {
            CleanOrphanFilesResult cleanOrphanFilesResult;
            switch (mode.toUpperCase(Locale.ROOT)) {
                case "DISTRIBUTED": {
                    cleanOrphanFilesResult = FlinkOrphanFilesClean.executeDatabaseOrphanFiles(procedureContext.getExecutionEnvironment(), this.catalog, OrphanFilesClean.olderThanMillis(olderThan), dryRun != null && dryRun != false, parallelism, databaseName, tableName);
                    break;
                }
                case "LOCAL": {
                    cleanOrphanFilesResult = LocalOrphanFilesClean.executeDatabaseOrphanFiles(this.catalog, databaseName, tableName, OrphanFilesClean.olderThanMillis(olderThan), parallelism, dryRun != null && dryRun != false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mode: " + mode + ". Only 'DISTRIBUTED' and 'LOCAL' are supported.");
                }
            }
            return new String[]{String.valueOf(cleanOrphanFilesResult.getDeletedFileCount()), String.valueOf(cleanOrphanFilesResult.getDeletedFileTotalLenInBytes())};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

