/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.RowLevelModificationScanContext;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsDeletePushDown;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelDelete;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelUpdate;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.types.logical.RowType;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.PredicateConverter;
import org.apache.paimon.flink.log.LogStoreTableFactory;
import org.apache.paimon.flink.sink.FlinkTableSink;
import org.apache.paimon.flink.sink.FlinkTableSinkBase;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.OnlyPartitionKeyEqualVisitor;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.utils.Preconditions;

public abstract class SupportsRowLevelOperationFlinkTableSink
extends FlinkTableSinkBase
implements SupportsRowLevelUpdate,
SupportsRowLevelDelete,
SupportsDeletePushDown {
    @Nullable
    protected Predicate deletePredicate;

    public SupportsRowLevelOperationFlinkTableSink(ObjectIdentifier tableIdentifier, Table table, DynamicTableFactory.Context context, @Nullable LogStoreTableFactory logStoreTableFactory) {
        super(tableIdentifier, table, context, logStoreTableFactory);
    }

    @Override
    public DynamicTableSink copy() {
        FlinkTableSink copied = new FlinkTableSink(this.tableIdentifier, this.table, this.context, this.logStoreTableFactory);
        copied.staticPartitions = new HashMap(this.staticPartitions);
        copied.overwrite = this.overwrite;
        copied.deletePredicate = this.deletePredicate;
        return copied;
    }

    public SupportsRowLevelUpdate.RowLevelUpdateInfo applyRowLevelUpdate(List<Column> updatedColumns, @Nullable RowLevelModificationScanContext context) {
        boolean supportUpdate;
        if (this.table.primaryKeys().isEmpty()) {
            throw new UnsupportedOperationException(String.format("%s can not support update, because there is no primary key.", this.table.getClass().getName()));
        }
        Options options = Options.fromMap(this.table.options());
        HashSet<String> primaryKeys = new HashSet<String>(this.table.primaryKeys());
        updatedColumns.forEach(column -> {
            if (primaryKeys.contains(column.getName())) {
                String errMsg = String.format("Updates to primary keys are not supported, primaryKeys (%s), updatedColumns (%s)", primaryKeys, updatedColumns.stream().map(Column::getName).collect(Collectors.toList()));
                throw new UnsupportedOperationException(errMsg);
            }
        });
        CoreOptions.MergeEngine mergeEngine = options.get(CoreOptions.MERGE_ENGINE);
        boolean bl = supportUpdate = mergeEngine == CoreOptions.MergeEngine.DEDUPLICATE || mergeEngine == CoreOptions.MergeEngine.PARTIAL_UPDATE;
        if (!supportUpdate) {
            throw new UnsupportedOperationException(String.format("Merge engine %s can not support batch update.", mergeEngine));
        }
        return new SupportsRowLevelUpdate.RowLevelUpdateInfo(){};
    }

    public SupportsRowLevelDelete.RowLevelDeleteInfo applyRowLevelDelete(@Nullable RowLevelModificationScanContext rowLevelModificationScanContext) {
        this.validateDeletable();
        return new SupportsRowLevelDelete.RowLevelDeleteInfo(){};
    }

    public boolean applyDeleteFilters(List<ResolvedExpression> list) {
        this.validateDeletable();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        RowType rowType = LogicalTypeConversion.toLogicalType(this.table.rowType());
        for (ResolvedExpression filter : list) {
            Optional<Predicate> predicate = PredicateConverter.convert(rowType, filter);
            if (predicate.isPresent()) {
                predicates.add(predicate.get());
                continue;
            }
            return false;
        }
        this.deletePredicate = predicates.isEmpty() ? null : PredicateBuilder.and(predicates);
        return this.canPushDownDeleteFilter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Long> executeDeletion() {
        try (BatchTableCommit commit = this.table.newBatchWriteBuilder().newCommit();){
            if (this.deletePredicate == null) {
                commit.truncateTable();
            } else {
                Preconditions.checkArgument(this.deleteIsDropPartition());
                commit.truncatePartitions(Collections.singletonList(this.deletePartitions()));
            }
            Optional<Long> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void validateDeletable() {
        if (this.table.primaryKeys().isEmpty()) {
            throw new UnsupportedOperationException(String.format("table '%s' can not support delete, because there is no primary key.", this.table.getClass().getName()));
        }
        Options options = Options.fromMap(this.table.options());
        CoreOptions.MergeEngine mergeEngine = options.get(CoreOptions.MERGE_ENGINE);
        switch (mergeEngine) {
            case DEDUPLICATE: {
                return;
            }
            case PARTIAL_UPDATE: {
                if (options.get(CoreOptions.PARTIAL_UPDATE_REMOVE_RECORD_ON_DELETE).booleanValue() || options.get(CoreOptions.PARTIAL_UPDATE_REMOVE_RECORD_ON_SEQUENCE_GROUP) != null) {
                    return;
                }
                throw new UnsupportedOperationException(String.format("Merge engine %s doesn't support batch delete by default. To support batch delete, please set %s to true when there is no %s or set %s.", mergeEngine, CoreOptions.PARTIAL_UPDATE_REMOVE_RECORD_ON_DELETE.key(), "sequence-group", CoreOptions.PARTIAL_UPDATE_REMOVE_RECORD_ON_SEQUENCE_GROUP));
            }
            case AGGREGATE: {
                if (options.get(CoreOptions.AGGREGATION_REMOVE_RECORD_ON_DELETE).booleanValue()) {
                    return;
                }
                throw new UnsupportedOperationException(String.format("Merge engine %s doesn't support batch delete by default. To support batch delete, please set %s to true.", mergeEngine, CoreOptions.AGGREGATION_REMOVE_RECORD_ON_DELETE.key()));
            }
        }
        throw new UnsupportedOperationException(String.format("Merge engine %s can not support batch delete.", mergeEngine));
    }

    private boolean canPushDownDeleteFilter() {
        CoreOptions options = CoreOptions.fromMap(this.table.options());
        return (this.deletePredicate == null || this.deleteIsDropPartition()) && !options.deleteForceProduceChangelog();
    }

    private boolean deleteIsDropPartition() {
        if (this.deletePredicate == null) {
            return false;
        }
        return this.deletePredicate.visit(new OnlyPartitionKeyEqualVisitor(this.table.partitionKeys()));
    }

    private Map<String, String> deletePartitions() {
        if (this.deletePredicate == null) {
            return null;
        }
        OnlyPartitionKeyEqualVisitor visitor = new OnlyPartitionKeyEqualVisitor(this.table.partitionKeys());
        this.deletePredicate.visit(visitor);
        return visitor.partitions();
    }
}

