/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.factories.Factory;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.utils.Preconditions;

@Public
public interface CatalogFactory
extends Factory {
    public Catalog create(FileIO var1, Path var2, CatalogContext var3);

    public static Path warehouse(CatalogContext context) {
        String warehouse = Preconditions.checkNotNull(context.options().get(CatalogOptions.WAREHOUSE), "Paimon '" + CatalogOptions.WAREHOUSE.key() + "' path must be set");
        return new Path(warehouse);
    }

    public static Catalog createCatalog(CatalogContext options) {
        return CatalogFactory.createCatalog(options, CatalogFactory.class.getClassLoader());
    }

    public static Catalog createCatalog(CatalogContext context, ClassLoader classLoader) {
        FileIO fileIO;
        String warehouse = CatalogFactory.warehouse(context).toUri().toString();
        String metastore = context.options().get(CatalogOptions.METASTORE);
        CatalogFactory catalogFactory = FactoryUtil.discoverFactory(classLoader, CatalogFactory.class, metastore);
        Path warehousePath = new Path(warehouse);
        try {
            fileIO = FileIO.get(warehousePath, context);
            if (fileIO.exists(warehousePath)) {
                Preconditions.checkArgument(fileIO.isDir(warehousePath), "The %s path '%s' should be a directory.", CatalogOptions.WAREHOUSE.key(), warehouse);
            } else {
                fileIO.mkdirs(warehousePath);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return catalogFactory.create(fileIO, warehousePath, context);
    }
}

