/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.SchemaManager;

public class CatalogUtils {
    public static Path path(String warehouse, String database, String table) {
        return new Path(String.format("%s/%s.db/%s", warehouse, database, table));
    }

    public static String stringifyPath(String warehouse, String database, String table) {
        return String.format("%s/%s.db/%s", warehouse, database, table);
    }

    public static String warehouse(Path path) {
        return path.getParent().getParent().getPath();
    }

    public static String warehouse(String path) {
        return new Path(path).getParent().getParent().getPath();
    }

    public static String database(Path path) {
        return SchemaManager.fromPath(path.getPath(), false).getDatabaseName();
    }

    public static String database(String path) {
        return SchemaManager.fromPath(path, false).getDatabaseName();
    }

    public static String table(Path path) {
        return SchemaManager.fromPath(path.getPath(), false).getObjectName();
    }

    public static String table(String path) {
        return SchemaManager.fromPath(path, false).getObjectName();
    }
}

