/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.memory.MemorySegment;

public final class BinaryRowTypeSerializer
extends TypeSerializer<BinaryRow> {
    private static final long serialVersionUID = 1L;
    private final BinaryRowSerializer serializer;

    public BinaryRowTypeSerializer(int numFields) {
        this.serializer = new BinaryRowSerializer(numFields);
    }

    public boolean isImmutableType() {
        return false;
    }

    public BinaryRowTypeSerializer duplicate() {
        return new BinaryRowTypeSerializer(this.serializer.getArity());
    }

    public BinaryRow createInstance() {
        return this.serializer.createInstance();
    }

    public BinaryRow copy(BinaryRow from) {
        return this.serializer.copy(from);
    }

    public BinaryRow copy(BinaryRow from, BinaryRow reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(BinaryRow record, DataOutputView target) throws IOException {
        target.writeInt(record.getSizeInBytes());
        target.write(record.toBytes());
    }

    public BinaryRow deserialize(DataInputView source) throws IOException {
        return this.deserialize(this.createInstance(), source);
    }

    public BinaryRow deserialize(BinaryRow reuse, DataInputView source) throws IOException {
        int len = source.readInt();
        byte[] bytes = new byte[len];
        source.readFully(bytes);
        reuse.pointTo(MemorySegment.wrap(bytes), 0, len);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BinaryRowTypeSerializer that = (BinaryRowTypeSerializer)((Object)o);
        return Objects.equals(this.serializer, that.serializer);
    }

    public int hashCode() {
        return Objects.hash(this.serializer);
    }

    public TypeSerializerSnapshot<BinaryRow> snapshotConfiguration() {
        return new BinaryRowTypeSerializerSnapshot(this.serializer.getArity());
    }

    public static class BinaryRowTypeSerializerSnapshot
    implements TypeSerializerSnapshot<BinaryRow> {
        private int numFields;

        public BinaryRowTypeSerializerSnapshot() {
        }

        private BinaryRowTypeSerializerSnapshot(int numFields) {
            this.numFields = numFields;
        }

        public int getCurrentVersion() {
            return 0;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.numFields);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.numFields = in.readInt();
        }

        public TypeSerializer<BinaryRow> restoreSerializer() {
            return new BinaryRowTypeSerializer(this.numFields);
        }

        public TypeSerializerSchemaCompatibility<BinaryRow> resolveSchemaCompatibility(TypeSerializer<BinaryRow> newSerializer) {
            if (!(newSerializer instanceof BinaryRowTypeSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            BinaryRowTypeSerializer other = (BinaryRowTypeSerializer)newSerializer;
            if (this.numFields == other.serializer.getArity()) {
                return TypeSerializerSchemaCompatibility.compatibleAsIs();
            }
            return TypeSerializerSchemaCompatibility.incompatible();
        }
    }
}

