/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.paimon.catalog.CatalogUtils;
import org.apache.paimon.factories.Factory;
import org.apache.paimon.factories.FactoryException;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ActionFactory
extends Factory {
    public static final Logger LOG = LoggerFactory.getLogger(ActionFactory.class);

    public Optional<Action> create(MultipleParameterTool var1);

    public static Optional<Action> createAction(String[] args) {
        ActionFactory actionFactory;
        String action = args[0].toLowerCase();
        CharSequence[] actionArgs = Arrays.copyOfRange(args, 1, args.length);
        try {
            actionFactory = FactoryUtil.discoverFactory(ActionFactory.class.getClassLoader(), ActionFactory.class, action);
        }
        catch (FactoryException e) {
            ActionFactory.printDefaultHelp();
            throw new UnsupportedOperationException("Unknown action \"" + action + "\".");
        }
        LOG.info("{} job args: {}", (Object)actionFactory.identifier(), (Object)String.join((CharSequence)" ", actionArgs));
        MultipleParameterTool params = MultipleParameterTool.fromArgs((String[])actionArgs);
        if (params.has("help")) {
            actionFactory.printHelp();
            return Optional.empty();
        }
        return actionFactory.create(params);
    }

    public void printHelp();

    public static void printDefaultHelp() {
        System.out.println("Usage: <action> [OPTIONS]");
        System.out.println();
        System.out.println("Available actions:");
        List<String> identifiers = FactoryUtil.discoverIdentifiers(ActionFactory.class.getClassLoader(), ActionFactory.class);
        identifiers.forEach(action -> System.out.println("  " + action));
        System.out.println("For detailed options of each action, run <action> --help");
    }

    default public Tuple3<String, String, String> getTablePath(MultipleParameterTool params) {
        String warehouse = params.get("warehouse");
        String database = params.get("database");
        String table = params.get("table");
        String path = params.get("path");
        Tuple3 tablePath = null;
        int count = 0;
        if (warehouse != null || database != null || table != null) {
            if (warehouse == null || database == null || table == null) {
                throw new IllegalArgumentException("Warehouse, database and table must be specified all at once to specify a table.");
            }
            tablePath = Tuple3.of((Object)warehouse, (Object)database, (Object)table);
            ++count;
        }
        if (path != null) {
            tablePath = Tuple3.of((Object)CatalogUtils.warehouse(path), (Object)CatalogUtils.database(path), (Object)CatalogUtils.table(path));
            ++count;
        }
        if (count != 1) {
            throw new IllegalArgumentException("Please specify either \"warehouse, database and table\" or \"path\".");
        }
        return tablePath;
    }

    default public List<Map<String, String>> getPartitions(MultipleParameterTool params) {
        ArrayList<Map<String, String>> partitions = new ArrayList<Map<String, String>>();
        for (String partition : params.getMultiParameter("partition")) {
            Map<String, String> kvs = ActionFactory.parseCommaSeparatedKeyValues(partition);
            partitions.add(kvs);
        }
        return partitions;
    }

    default public Map<String, String> optionalConfigMap(MultipleParameterTool params, String key) {
        if (!params.has(key)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> config = new HashMap<String, String>();
        for (String kvString : params.getMultiParameter(key)) {
            ActionFactory.parseKeyValueString(config, kvString);
        }
        return config;
    }

    default public void checkRequiredArgument(MultipleParameterTool params, String key) {
        Preconditions.checkArgument(params.has(key), "Argument '%s' is required. Run '<action> --help' for help.", key);
    }

    default public String getRequiredValue(MultipleParameterTool params, String key) {
        this.checkRequiredArgument(params, key);
        return params.get(key);
    }

    public static Map<String, String> parseCommaSeparatedKeyValues(String keyValues) {
        HashMap<String, String> kvs = new HashMap<String, String>();
        for (String kvString : keyValues.split(",")) {
            ActionFactory.parseKeyValueString(kvs, kvString);
        }
        return kvs;
    }

    public static void parseKeyValueString(Map<String, String> map, String kvString) {
        String[] kv = kvString.split("=", 2);
        if (kv.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid key-value string '%s'. Please use format 'key=value'", kvString));
        }
        map.put(kv[0].trim(), kv[1].trim());
    }
}

