/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.CompactAction;
import org.apache.paimon.flink.action.SortCompactAction;

public class CompactActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "compact";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterTool params) {
        CompactAction action;
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog-conf");
        if (params.has("order-strategy")) {
            String sqlOrderBy;
            SortCompactAction sortCompactAction = new SortCompactAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig);
            String strategy = params.get("order-strategy");
            sortCompactAction.withOrderStrategy(strategy);
            if (params.has("order-by")) {
                sqlOrderBy = params.get("order-by");
                if (sqlOrderBy == null) {
                    throw new IllegalArgumentException("Please specify \"order-by\".");
                }
            } else {
                throw new IllegalArgumentException("Please specify order columns in parameter --order-by.");
            }
            sortCompactAction.withOrderColumns(Arrays.asList(sqlOrderBy.split(",")));
            action = sortCompactAction;
        } else {
            action = new CompactAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig);
        }
        if (params.has("partition")) {
            List<Map<String, String>> partitions = this.getPartitions(params);
            action.withPartitions(partitions);
        }
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"compact\" runs a dedicated job for compacting specified table.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  compact --warehouse <warehouse-path> --database <database-name> --table <table-name> [--partition <partition-name>][--order-strategy <order-strategy>][--order-by <order-columns>]");
        System.out.println("  compact --warehouse s3://path/to/warehouse --database <database-name> --table <table-name> [--catalog-conf <paimon-catalog-conf> [--catalog-conf <paimon-catalog-conf> ...]]");
        System.out.println("  compact --path <table-path> [--partition <partition-name>]");
        System.out.println();
        System.out.println("Partition name syntax:");
        System.out.println("  key1=value1,key2=value2,...");
        System.out.println();
        System.out.println("Note:");
        System.out.println("  order compact now only support append-only table with bucket=-1, please don't specify --order-strategy parameter if your table does not meet the request");
        System.out.println("  order-strategy now only support zorder in batch mode");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  compact --warehouse hdfs:///path/to/warehouse --database test_db --table test_table");
        System.out.println("  compact --path hdfs:///path/to/warehouse/test_db.db/test_table --partition dt=20221126,hh=08");
        System.out.println("  compact --warehouse hdfs:///path/to/warehouse --database test_db --table test_table --partition dt=20221126,hh=08 --partition dt=20221127,hh=09");
        System.out.println("  compact --warehouse s3:///path/to/warehouse --database test_db --table test_table --order-strategy zorder --order-by a,b,c --catalog-conf s3.endpoint=https://****.com --catalog-conf s3.access-key=***** --catalog-conf s3.secret-key=***** ");
    }
}

