/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.CreateTagAction;

public class CreateTagActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "create-tag";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterTool params) {
        this.checkRequiredArgument(params, "tag-name");
        this.checkRequiredArgument(params, "snapshot");
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog-conf");
        String tagName = params.get("tag-name");
        long snapshot = Long.parseLong(params.get("snapshot"));
        CreateTagAction action = new CreateTagAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig, tagName, snapshot);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"create-tag\" creates a tag from given snapshot.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  create-tag --warehouse <warehouse-path> --database <database-name> --table <table-name> --tag-name <tag-name> --snapshot <snapshot-id>");
        System.out.println();
    }
}

