/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.DeleteTagAction;

public class DeleteTagActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "delete-tag";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterTool params) {
        this.checkRequiredArgument(params, "tag-name");
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog-conf");
        String tagName = params.get("tag-name");
        DeleteTagAction action = new DeleteTagAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig, tagName);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"delete-tag\" deletes a tag by name.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  delete-tag --warehouse <warehouse-path> --database <database-name> --table <table-name> --tag-name <tag-name>");
        System.out.println();
    }
}

