/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.DropPartitionAction;

public class DropPartitionActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "drop-partition";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterTool params) {
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        this.checkRequiredArgument(params, "partition");
        List<Map<String, String>> partitions = this.getPartitions(params);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog-conf");
        return Optional.of(new DropPartitionAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, partitions, catalogConfig));
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"drop-partition\" drops data of specified partitions for a table.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  drop-partition --warehouse <warehouse-path> --database <database-name> --table <table-name> --partition <partition-name> [--partition <partition-name> ...]");
        System.out.println("  drop-partition --path <table-path> --partition <partition-name> [--partition <partition-name> ...]");
        System.out.println();
        System.out.println("Partition name syntax:");
        System.out.println("  key1=value1,key2=value2,...");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  drop-partition --warehouse hdfs:///path/to/warehouse --database test_db --table test_table --partition dt=20221126,hh=08");
        System.out.println("  drop-partition --path hdfs:///path/to/warehouse/test_db.db/test_table --partition dt=20221126,hh=08 --partition dt=20221127,hh=09");
    }
}

