/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.RollbackToAction;

public class RollbackToActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "rollback-to";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterTool params) {
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        this.checkRequiredArgument(params, "version");
        String version = params.get("version");
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog-conf");
        RollbackToAction action = new RollbackToAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, version, catalogConfig);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"rollback-to\" roll back a table to a specific snapshot ID or tag.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  rollback-to --warehouse <warehouse-path> --database <database-name> --table <table-name> --version <version-string>");
        System.out.println("  'version-string can be a long value representing a snapshot ID or a tag name.'");
        System.out.println();
    }
}

