/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<TypeMappingMode> typeMappingModes;

    public TypeMapping(Set<TypeMappingMode> typeMappingModes) {
        this.typeMappingModes = typeMappingModes;
    }

    public boolean containsMode(TypeMappingMode mode) {
        return this.typeMappingModes.contains((Object)mode);
    }

    public static TypeMapping defaultMapping() {
        return new TypeMapping(Collections.emptySet());
    }

    public static TypeMapping parse(String[] rawOptions) {
        List options = Arrays.stream(rawOptions).map(String::trim).map(String::toLowerCase).collect(Collectors.toList());
        HashSet<TypeMappingMode> typeMappingModes = new HashSet<TypeMappingMode>();
        block10: for (String option : options) {
            switch (option.toLowerCase()) {
                case "tinyint1-not-bool": {
                    typeMappingModes.add(TypeMappingMode.TINYINT1_NOT_BOOL);
                    continue block10;
                }
                case "to-nullable": {
                    typeMappingModes.add(TypeMappingMode.TO_NULLABLE);
                    continue block10;
                }
                case "to-string": {
                    typeMappingModes.add(TypeMappingMode.TO_STRING);
                    continue block10;
                }
            }
            throw new UnsupportedOperationException("Unsupported type mapping option: " + option);
        }
        return new TypeMapping(typeMappingModes);
    }

    public static enum TypeMappingMode {
        TINYINT1_NOT_BOOL,
        TO_NULLABLE,
        TO_STRING;

    }
}

