/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.kafka.formats;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;
import org.apache.paimon.flink.action.cdc.TableNameConverter;
import org.apache.paimon.flink.action.cdc.kafka.KafkaSchema;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

public abstract class RecordParser
implements FlatMapFunction<String, RichCdcMultiplexRecord> {
    protected static final String FIELD_TABLE = "table";
    protected static final String FIELD_DATABASE = "database";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final TableNameConverter tableNameConverter;
    protected JsonNode root;
    protected String databaseName;
    protected String tableName;
    protected boolean caseSensitive;

    protected abstract List<RichCdcMultiplexRecord> extractRecords();

    protected abstract void validateFormat();

    protected abstract String extractString(String var1);

    public abstract KafkaSchema getKafkaSchema(String var1);

    public RecordParser(TableNameConverter tableNameConverter, boolean caseSensitive) {
        this.tableNameConverter = tableNameConverter;
        this.caseSensitive = caseSensitive;
    }

    public void flatMap(String value, Collector<RichCdcMultiplexRecord> out) throws Exception {
        this.root = OBJECT_MAPPER.readValue(value, JsonNode.class);
        this.validateFormat();
        this.databaseName = this.extractString(FIELD_DATABASE);
        this.tableName = this.tableNameConverter.convert(this.extractString(FIELD_TABLE));
        this.extractRecords().forEach(arg_0 -> out.collect(arg_0));
    }

    protected Map<String, String> keyCaseInsensitive(Map<String, String> origin) {
        HashMap<String, String> keyCaseInsensitive = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : origin.entrySet()) {
            String fieldName = entry.getKey().toLowerCase();
            Preconditions.checkArgument(!keyCaseInsensitive.containsKey(fieldName), "Duplicate key appears when converting map keys to case-insensitive form. Original map is:\n%s", origin);
            keyCaseInsensitive.put(fieldName, entry.getValue());
        }
        return keyCaseInsensitive;
    }

    protected List<String> extractPrimaryKeys(String primaryKeys) {
        return StreamSupport.stream(this.root.get(primaryKeys).spliterator(), false).map(pk -> this.toFieldName(pk.asText())).collect(Collectors.toList());
    }

    protected String toFieldName(String rawName) {
        return StringUtils.caseSensitiveConversion(rawName, this.caseSensitive);
    }
}

