/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.kafka.formats.ogg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.TableNameConverter;
import org.apache.paimon.flink.action.cdc.kafka.KafkaSchema;
import org.apache.paimon.flink.action.cdc.kafka.formats.RecordParser;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

public class OggRecordParser
extends RecordParser {
    private static final DataType STRING_DATA_TYPE = DataTypes.STRING();
    private static final String FIELD_PRIMARY_KEYS = "primary_keys";
    private static final String FIELD_BEFORE = "before";
    private static final String FIELD_AFTER = "after";
    private static final String FIELD_TYPE = "op_type";
    private static final String OP_UPDATE = "U";
    private static final String OP_INSERT = "I";
    private static final String OP_DELETE = "D";
    private final List<ComputedColumn> computedColumns;

    public OggRecordParser(boolean caseSensitive, TableNameConverter tableNameConverter, List<ComputedColumn> computedColumns) {
        super(tableNameConverter, caseSensitive);
        this.computedColumns = computedColumns;
    }

    @Override
    public List<RichCdcMultiplexRecord> extractRecords() {
        String type;
        ArrayList<RichCdcMultiplexRecord> records = new ArrayList<RichCdcMultiplexRecord>();
        switch (type = this.extractString(FIELD_TYPE)) {
            case "U": {
                this.processRecord(this.root.get(FIELD_BEFORE), RowKind.DELETE, records);
                this.processRecord(this.root.get(FIELD_AFTER), RowKind.INSERT, records);
                break;
            }
            case "I": {
                this.processRecord(this.root.get(FIELD_AFTER), RowKind.INSERT, records);
                break;
            }
            case "D": {
                this.processRecord(this.root.get(FIELD_BEFORE), RowKind.DELETE, records);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown record type: " + type);
            }
        }
        return records;
    }

    private void processRecord(JsonNode jsonNode, RowKind rowKind, List<RichCdcMultiplexRecord> records) {
        LinkedHashMap<String, DataType> paimonFieldTypes = new LinkedHashMap<String, DataType>();
        Map<String, String> rowData = this.extractRow(jsonNode, paimonFieldTypes);
        rowData = this.caseSensitive ? rowData : this.keyCaseInsensitive(rowData);
        records.add(this.createRecord(rowKind, rowData, paimonFieldTypes));
    }

    private RichCdcMultiplexRecord createRecord(RowKind rowKind, Map<String, String> data, LinkedHashMap<String, DataType> paimonFieldTypes) {
        return new RichCdcMultiplexRecord(this.databaseName, this.tableName, paimonFieldTypes, this.extractPrimaryKeys(FIELD_PRIMARY_KEYS), new CdcRecord(rowKind, data));
    }

    @Override
    public KafkaSchema getKafkaSchema(String record) {
        try {
            this.root = OBJECT_MAPPER.readValue(record, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error processing JSON: " + record, e);
        }
        this.validateFormat();
        LinkedHashMap<String, DataType> paimonFieldTypes = this.extractFieldTypesFromOracleType();
        return new KafkaSchema(this.databaseName, this.tableName, paimonFieldTypes, this.extractPrimaryKeys(FIELD_PRIMARY_KEYS));
    }

    @Override
    protected void validateFormat() {
        String fieldType;
        String errorMessageTemplate = "Didn't find '%s' node in json. Please make sure your topic's format is correct.";
        Preconditions.checkNotNull(this.root.get("table"), errorMessageTemplate, "table");
        Preconditions.checkNotNull(this.root.get(FIELD_TYPE), errorMessageTemplate, FIELD_TYPE);
        Preconditions.checkNotNull(this.root.get(FIELD_PRIMARY_KEYS), errorMessageTemplate, FIELD_PRIMARY_KEYS);
        switch (fieldType = this.root.get(FIELD_TYPE).asText()) {
            case "U": {
                Preconditions.checkNotNull(this.root.get(FIELD_AFTER), errorMessageTemplate, FIELD_AFTER);
                Preconditions.checkNotNull(this.root.get(FIELD_BEFORE), errorMessageTemplate, FIELD_BEFORE);
                break;
            }
            case "I": {
                Preconditions.checkNotNull(this.root.get(FIELD_AFTER), errorMessageTemplate, FIELD_AFTER);
                break;
            }
            case "D": {
                Preconditions.checkNotNull(this.root.get(FIELD_BEFORE), errorMessageTemplate, FIELD_BEFORE);
                Preconditions.checkNotNull(this.root.get(FIELD_AFTER), errorMessageTemplate, "null");
            }
        }
    }

    @Override
    protected String extractString(String key) {
        if (key.equals("table")) {
            this.extractDatabaseAndTableNames();
            return this.tableName;
        }
        if (key.equals("database")) {
            this.extractDatabaseAndTableNames();
            return this.databaseName;
        }
        return this.root.get(key) != null ? this.root.get(key).asText() : null;
    }

    private void extractDatabaseAndTableNames() {
        String[] dbt;
        JsonNode tableNode = this.root.get("table");
        if (tableNode != null && (dbt = tableNode.asText().split("\\.", 2)).length == 2) {
            this.databaseName = dbt[0];
            this.tableName = dbt[1];
        }
    }

    private LinkedHashMap<String, DataType> extractFieldTypesFromOracleType() {
        String[] columns;
        LinkedHashMap<String, DataType> fieldTypes = new LinkedHashMap<String, DataType>();
        JsonNode record = this.root.get(FIELD_AFTER);
        Map linkedHashMap = OBJECT_MAPPER.convertValue((Object)record, new TypeReference<LinkedHashMap<String, Object>>(){});
        if (linkedHashMap == null) {
            return new LinkedHashMap<String, DataType>();
        }
        Set keySet = linkedHashMap.keySet();
        for (String column : columns = keySet.toArray(new String[0])) {
            fieldTypes.put(this.toFieldName(column), DataTypes.STRING());
        }
        return fieldTypes;
    }

    private Map<String, String> extractRow(JsonNode record, LinkedHashMap<String, DataType> paimonFieldTypes) {
        Map linkedHashMap = OBJECT_MAPPER.convertValue((Object)record, new TypeReference<LinkedHashMap<String, String>>(){});
        if (linkedHashMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        linkedHashMap.forEach((key, value) -> {
            paimonFieldTypes.put((String)key, STRING_DATA_TYPE);
            resultMap.put((String)key, (String)value);
        });
        this.computedColumns.forEach(computedColumn -> {
            resultMap.put(computedColumn.columnName(), computedColumn.eval((String)resultMap.get(computedColumn.fieldReference())));
            paimonFieldTypes.put(computedColumn.columnName(), STRING_DATA_TYPE);
        });
        return resultMap;
    }
}

