/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.ververica.cdc.connectors.base.options.SourceOptions;
import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.mongodb.source.MongoDBSource;
import com.ververica.cdc.connectors.mongodb.source.MongoDBSourceBuilder;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.JsonDebeziumDeserializationSchema;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.flink.action.cdc.mongodb.MongodbSchema;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.Preconditions;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDBActionUtils {
    public static final ConfigOption<String> FIELD_NAME = ConfigOptions.key((String)"field.name").stringType().noDefaultValue().withDescription("Set the field names to be synchronized in the  `specified` mode.");
    public static final ConfigOption<String> PARSER_PATH = ConfigOptions.key((String)"parser.path").stringType().noDefaultValue().withDescription("Configure the JSON parsing path for synchronizing field values in the `specified` mode.");
    public static final ConfigOption<String> START_MODE = ConfigOptions.key((String)"schema.start.mode").stringType().defaultValue((Object)"dynamic").withDescription("Can choose between the `dynamic` and `specified` modes.");

    static MongoDBSource<String> buildMongodbSource(Configuration mongodbConfig, String tableList) {
        MongoDBActionUtils.validateMongodbConfig(mongodbConfig);
        MongoDBSourceBuilder sourceBuilder = MongoDBSource.builder();
        if (mongodbConfig.contains(MongoDBSourceOptions.USERNAME) && mongodbConfig.contains(MongoDBSourceOptions.PASSWORD)) {
            sourceBuilder.username((String)mongodbConfig.get(MongoDBSourceOptions.USERNAME)).password((String)mongodbConfig.get(MongoDBSourceOptions.PASSWORD));
        }
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.CONNECTION_OPTIONS)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).connectionOptions(arg_0));
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.BATCH_SIZE)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).batchSize(arg_0));
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.HEARTBEAT_INTERVAL_MILLIS)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).heartbeatIntervalMillis(arg_0));
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.SCHEME)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).scheme(arg_0));
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.POLL_MAX_BATCH_SIZE)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).pollMaxBatchSize(arg_0));
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.POLL_AWAIT_TIME_MILLIS)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).pollAwaitTimeMillis(arg_0));
        sourceBuilder.hosts((String)mongodbConfig.get(MongoDBSourceOptions.HOSTS)).databaseList(new String[]{(String)mongodbConfig.get(MongoDBSourceOptions.DATABASE)}).collectionList(new String[]{tableList});
        String startupMode = (String)mongodbConfig.get(SourceOptions.SCAN_STARTUP_MODE);
        if ("initial".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.initial());
        } else if ("latest-offset".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.latest());
        } else if ("timestamp".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.timestamp((long)((Long)mongodbConfig.get(SourceOptions.SCAN_STARTUP_TIMESTAMP_MILLIS))));
        }
        HashMap<String, String> customConverterConfigs = new HashMap<String, String>();
        customConverterConfigs.put("decimal.format", "numeric");
        JsonDebeziumDeserializationSchema schema = new JsonDebeziumDeserializationSchema(Boolean.valueOf(false), customConverterConfigs);
        return sourceBuilder.deserializer((DebeziumDeserializationSchema)schema).build();
    }

    private static void validateMongodbConfig(Configuration mongodbConfig) {
        Preconditions.checkArgument(mongodbConfig.get(MongoDBSourceOptions.HOSTS) != null, String.format("mongodb-conf [%s] must be specified.", MongoDBSourceOptions.HOSTS.key()));
        Preconditions.checkArgument(mongodbConfig.get(MongoDBSourceOptions.DATABASE) != null, String.format("mongodb-conf [%s] must be specified.", MongoDBSourceOptions.DATABASE.key()));
    }

    static Schema buildPaimonSchema(MongodbSchema mongodbSchema, List<String> specifiedPartitionKeys, Map<String, String> paimonConfig, boolean caseSensitive) {
        Map<String, DataType> mongodbFields;
        Schema.Builder builder = Schema.newBuilder();
        builder.options(paimonConfig);
        if (caseSensitive) {
            mongodbFields = mongodbSchema.fields();
        } else {
            mongodbFields = new LinkedHashMap<String, DataType>();
            for (Map.Entry<String, DataType> entry : mongodbSchema.fields().entrySet()) {
                String fieldName = entry.getKey();
                Preconditions.checkArgument(!mongodbFields.containsKey(fieldName.toLowerCase()), String.format("Duplicate key '%s' in table '%s' appears when converting fields map keys to case-insensitive form.", fieldName, mongodbSchema.tableName()));
                mongodbFields.put(fieldName.toLowerCase(), entry.getValue());
            }
        }
        for (Map.Entry<String, DataType> entry : mongodbFields.entrySet()) {
            builder.column(entry.getKey(), entry.getValue());
        }
        builder.primaryKey(Lists.newArrayList("_id"));
        if (specifiedPartitionKeys.size() > 0) {
            builder.partitionKeys(specifiedPartitionKeys);
        }
        return builder.build();
    }

    public static int getMongoDBVersion(Configuration mongodbConfig) {
        String hosts = (String)mongodbConfig.get(MongoDBSourceOptions.HOSTS);
        String databaseName = (String)mongodbConfig.get(MongoDBSourceOptions.DATABASE);
        String url = String.format("mongodb://%s/%s", hosts, databaseName);
        try (MongoClient mongoClient = MongoClients.create((String)url);){
            MongoDatabase database = mongoClient.getDatabase(databaseName);
            Document buildInfo = database.runCommand((Bson)new Document("buildInfo", (Object)1));
            String[] split = ((String)buildInfo.get((Object)"version")).split("\\.");
            int n = Integer.parseInt(split[0]);
            return n;
        }
    }
}

