/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.apache.paimon.flink.action.cdc.TableNameConverter;
import org.apache.paimon.flink.action.cdc.mongodb.strategy.Mongo4VersionStrategy;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class MongoDBRecordParser
implements FlatMapFunction<String, RichCdcMultiplexRecord> {
    private static final String FIELD_DATABASE = "db";
    private static final String FIELD_TABLE = "coll";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final boolean caseSensitive;
    private final TableNameConverter tableNameConverter;
    private final Configuration mongodbConfig;
    private JsonNode root;

    public MongoDBRecordParser(boolean caseSensitive, Configuration mongodbConfig) {
        this(caseSensitive, new TableNameConverter(caseSensitive), mongodbConfig);
    }

    public MongoDBRecordParser(boolean caseSensitive, TableNameConverter tableNameConverter, Configuration mongodbConfig) {
        this.caseSensitive = caseSensitive;
        this.tableNameConverter = tableNameConverter;
        this.mongodbConfig = mongodbConfig;
    }

    public void flatMap(String value, Collector<RichCdcMultiplexRecord> out) throws Exception {
        this.root = this.objectMapper.readValue(value, JsonNode.class);
        String databaseName = this.extractString(FIELD_DATABASE);
        String collection = this.tableNameConverter.convert(this.extractString(FIELD_TABLE));
        Mongo4VersionStrategy versionStrategy = new Mongo4VersionStrategy(databaseName, collection, this.caseSensitive, this.mongodbConfig);
        versionStrategy.extractRecords(this.root).forEach(arg_0 -> out.collect(arg_0));
    }

    private String extractString(String key) {
        return this.root.get("ns").get(key).asText();
    }
}

