/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBSyncTableAction;

public class MongoDBSyncTableActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "mongodb-sync-table";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterTool params) {
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        List<String> partitionKeys = Collections.emptyList();
        if (params.has("partition-keys")) {
            partitionKeys = Arrays.stream(params.get("partition-keys").split(",")).collect(Collectors.toList());
        }
        this.checkRequiredArgument(params, "mongodb-conf");
        Map<String, String> mongodbConfig = this.optionalConfigMap(params, "mongodb-conf");
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog-conf");
        Map<String, String> tableConfig = this.optionalConfigMap(params, "table-conf");
        return Optional.of(new MongoDBSyncTableAction(mongodbConfig, (String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, partitionKeys, catalogConfig, tableConfig));
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"mongodb-sync-table\" creates a streaming job with a Flink mongodb CDC source and a Paimon table sink to consume CDC events.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  mongodb-sync-table --warehouse <warehouse-path> --database <database-name> --table <table-name> [--partition-keys <partition-keys>] [--mongodb-conf <mongodb-cdc-source-conf> [--mongodb-conf <mongodb-cdc-source-conf> ...]] [--catalog-conf <paimon-catalog-conf> [--catalog-conf <paimon-catalog-conf> ...]] [--table-conf <paimon-table-sink-conf> [--table-conf <paimon-table-sink-conf> ...]]");
        System.out.println();
        System.out.println("Partition keys syntax:");
        System.out.println("  key1,key2,...");
        System.out.println("If partition key is not defined and the specified Paimon table does not exist, this action will automatically create an unpartitioned Paimon table.");
        System.out.println();
        System.out.println("mongodb CDC source conf syntax:");
        System.out.println("  key=value");
        System.out.println("'hosts', 'username', 'password', 'database' and 'collection' are required configurations, others are optional.");
        System.out.println("The 'mongodb-conf' introduces the 'schema.start.mode' parameter on top of the MongoDB CDC source configuration. 'schema.start.mode' provides two modes: 'dynamic' (default) and 'specified'.In 'dynamic' mode, MongoDB schema information is parsed at one level, which forms the basis for schema change evolution.In 'specified' mode, synchronization takes place according to specified criteria.This can be done by configuring 'field.name' to specify the synchronization fields and 'parser.path' to specify the JSON parsing path for those fields.");
        System.out.println("For a complete list of supported configurations, see https://ververica.github.io/flink-cdc-connectors/master/content/connectors/mongodb-cdc.html#connector-options");
        System.out.println();
        System.out.println("Paimon catalog and table sink conf syntax:");
        System.out.println("  key=value");
        System.out.println("For a complete list of supported configurations, see https://paimon.apache.org/docs/master/maintenance/configurations/");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  mongodb-sync-table \\\n    --warehouse hdfs:///path/to/warehouse \\\n    --database test_db \\\n    --table test_table \\\n    --partition-keys pt \\\n    --mongodb-conf hosts=127.0.0.1:27017 \\\n    --mongodb-conf username=root \\\n    --mongodb-conf password=123456 \\\n    --mongodb-conf database=source_db \\\n    --mongodb-conf collection='source_table' \\\n    --catalog-conf metastore=hive \\\n    --catalog-conf uri=thrift://hive-metastore:9083 \\\n    --table-conf bucket=4 \\\n    --table-conf changelog-producer=input \\\n    --table-conf sink.parallelism=4");
    }
}

