/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.flink.action.cdc.mongodb.ModeEnum;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBActionUtils;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.bson.Document;

public class MongodbSchema {
    private final String databaseName;
    private final String tableName;
    private final Map<String, DataType> fields;
    private final List<String> primaryKeys;

    public MongodbSchema(String databaseName, String tableName, Map<String, DataType> fields, List<String> primaryKeys) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.fields = fields;
        this.primaryKeys = primaryKeys;
    }

    public String tableName() {
        return this.tableName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public Map<String, DataType> fields() {
        return this.fields;
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public static MongodbSchema getMongodbSchema(Configuration mongodbConfig) {
        ModeEnum mode = ModeEnum.valueOf(((String)mongodbConfig.get(MongoDBActionUtils.START_MODE)).toUpperCase());
        String hosts = (String)mongodbConfig.get(MongoDBSourceOptions.HOSTS);
        String databaseName = (String)mongodbConfig.get(MongoDBSourceOptions.DATABASE);
        String collectionName = (String)mongodbConfig.get(MongoDBSourceOptions.COLLECTION);
        switch (mode) {
            case SPECIFIED: {
                String[] columnNames = ((String)mongodbConfig.get(MongoDBActionUtils.FIELD_NAME)).split(",");
                Map<String, DataType> schemaFields = MongodbSchema.generateSchemaFields(Arrays.asList(columnNames));
                return new MongodbSchema(databaseName, collectionName, schemaFields, Lists.newArrayList("_id"));
            }
            case DYNAMIC: {
                String url = String.format("mongodb://%s/%s", hosts, databaseName);
                try (MongoClient mongoClient = MongoClients.create((String)url);){
                    MongoDatabase database = mongoClient.getDatabase(databaseName);
                    MongoCollection collection = database.getCollection(collectionName);
                    Document firstDocument = (Document)collection.find().first();
                    MongodbSchema mongodbSchema = MongodbSchema.createMongodbSchema(databaseName, collectionName, MongodbSchema.getColumnNames(firstDocument));
                    return mongodbSchema;
                }
            }
        }
        throw new RuntimeException();
    }

    private static List<String> getColumnNames(Document document) {
        if (document != null) {
            return new ArrayList<String>(document.keySet());
        }
        return null;
    }

    private static Map<String, DataType> generateSchemaFields(List<String> columnNames) {
        LinkedHashMap<String, DataType> schemaFields = new LinkedHashMap<String, DataType>();
        if (columnNames != null) {
            for (String columnName : columnNames) {
                schemaFields.put(columnName, DataTypes.STRING());
            }
        }
        return schemaFields;
    }

    private static MongodbSchema createMongodbSchema(String databaseName, String collectionName, List<String> columnNames) {
        Map<String, DataType> schemaFields = MongodbSchema.generateSchemaFields(columnNames);
        return new MongodbSchema(databaseName, collectionName, schemaFields, Lists.newArrayList("_id"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MongodbSchema)) {
            return false;
        }
        MongodbSchema that = (MongodbSchema)o;
        return this.databaseName.equals(that.databaseName) && this.tableName.equals(that.tableName) && this.fields.equals(that.fields) && this.primaryKeys.equals(that.primaryKeys);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.tableName, this.fields, this.primaryKeys);
    }
}

