/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import com.ververica.cdc.connectors.mysql.source.MySqlSource;
import com.ververica.cdc.connectors.mysql.source.MySqlSourceBuilder;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffsetBuilder;
import com.ververica.cdc.connectors.mysql.table.StartupOptions;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.JsonDebeziumDeserializationSchema;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.mysql.schema.MySqlSchema;
import org.apache.paimon.flink.action.cdc.mysql.schema.MySqlSchemasInfo;
import org.apache.paimon.flink.action.cdc.mysql.schema.MySqlTableInfo;
import org.apache.paimon.flink.sink.cdc.UpdatedDataFieldsProcessFunction;
import org.apache.paimon.flink.sink.cdc.UpdatedDataFieldsProcessFunctionBase;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlActionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlActionUtils.class);
    public static final ConfigOption<Boolean> SCAN_NEWLY_ADDED_TABLE_ENABLED = ConfigOptions.key((String)"scan.newly-added-table.enabled").booleanType().defaultValue((Object)true).withDescription("Whether capture the scan the newly added tables or not, by default is true.");

    static Connection getConnection(Configuration mySqlConfig, boolean tinyint1NotBool) throws Exception {
        String url = String.format("jdbc:mysql://%s:%d%s", mySqlConfig.get(MySqlSourceOptions.HOSTNAME), mySqlConfig.get(MySqlSourceOptions.PORT), tinyint1NotBool ? "?tinyInt1isBit=false" : "");
        return DriverManager.getConnection(url, (String)mySqlConfig.get(MySqlSourceOptions.USERNAME), (String)mySqlConfig.get(MySqlSourceOptions.PASSWORD));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MySqlSchemasInfo getMySqlTableInfos(Configuration mySqlConfig, Predicate<String> monitorTablePredication, List<Identifier> excludedTables, TypeMapping typeMapping) throws Exception {
        Pattern databasePattern = Pattern.compile((String)mySqlConfig.get(MySqlSourceOptions.DATABASE_NAME));
        MySqlSchemasInfo mySqlSchemasInfo = new MySqlSchemasInfo();
        try (Connection conn = MySqlActionUtils.getConnection(mySqlConfig, typeMapping.containsMode(TypeMapping.TypeMappingMode.TINYINT1_NOT_BOOL));){
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet schemas = metaData.getCatalogs();){
                while (schemas.next()) {
                    ResultSet tables;
                    block36: {
                        String databaseName = schemas.getString("TABLE_CAT");
                        Matcher databaseMatcher = databasePattern.matcher(databaseName);
                        if (!databaseMatcher.matches()) continue;
                        tables = metaData.getTables(databaseName, null, "%", null);
                        Throwable throwable = null;
                        try {
                            while (tables.next()) {
                                String tableName = tables.getString("TABLE_NAME");
                                MySqlSchema mySqlSchema = MySqlSchema.buildSchema(metaData, databaseName, tableName, typeMapping);
                                Identifier identifier = Identifier.create(databaseName, tableName);
                                if (monitorTablePredication.test(tableName)) {
                                    mySqlSchemasInfo.addSchema(identifier, mySqlSchema);
                                    continue;
                                }
                                excludedTables.add(identifier);
                            }
                            if (tables == null) continue;
                            if (throwable == null) break block36;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (tables == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        tables.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                tables.close();
                                throw throwable3;
                            }
                        }
                        try {
                            tables.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    tables.close();
                }
                return mySqlSchemasInfo;
            }
        }
    }

    static void assertSchemaCompatible(TableSchema paimonSchema, Schema mySqlSchema) {
        if (!MySqlActionUtils.schemaCompatible(paimonSchema, mySqlSchema)) {
            throw new IllegalArgumentException("Paimon schema and MySQL schema are not compatible.\nPaimon fields are: " + paimonSchema.fields() + ".\nMySQL fields are: " + mySqlSchema.fields());
        }
    }

    static boolean schemaCompatible(TableSchema paimonSchema, Schema mySqlSchema) {
        for (DataField field : mySqlSchema.fields()) {
            int idx = paimonSchema.fieldNames().indexOf(field.name());
            if (idx < 0) {
                LOG.info("Cannot find field '{}' in Paimon table.", (Object)field.name());
                return false;
            }
            DataType type = paimonSchema.fields().get(idx).type();
            if (UpdatedDataFieldsProcessFunction.canConvert(field.type(), type) == UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT) continue;
            LOG.info("Cannot convert field '{}' from MySQL type '{}' to Paimon type '{}'.", new Object[]{field.name(), field.type(), type});
            return false;
        }
        return true;
    }

    static Schema buildPaimonSchema(MySqlTableInfo mySqlTableInfo, List<String> specifiedPartitionKeys, List<String> specifiedPrimaryKeys, List<ComputedColumn> computedColumns, Map<String, String> paimonConfig, boolean caseSensitive) {
        List<String> mySqlPrimaryKeys;
        LinkedHashMap<String, Pair<DataType, String>> mySqlFields;
        Schema.Builder builder = Schema.newBuilder();
        builder.options(paimonConfig);
        MySqlSchema mySqlSchema = mySqlTableInfo.schema();
        if (caseSensitive) {
            mySqlFields = mySqlSchema.fields();
            mySqlPrimaryKeys = mySqlSchema.primaryKeys();
        } else {
            mySqlFields = new LinkedHashMap();
            for (Map.Entry<String, Pair<DataType, String>> entry : mySqlSchema.fields().entrySet()) {
                String fieldName = entry.getKey();
                Preconditions.checkArgument(!mySqlFields.containsKey(fieldName.toLowerCase()), String.format("Duplicate key '%s' in table '%s' appears when converting fields map keys to case-insensitive form.", fieldName, mySqlTableInfo.location()));
                mySqlFields.put(fieldName.toLowerCase(), entry.getValue());
            }
            mySqlPrimaryKeys = mySqlSchema.primaryKeys().stream().map(String::toLowerCase).collect(Collectors.toList());
        }
        for (Map.Entry<String, Pair<DataType, String>> entry : mySqlFields.entrySet()) {
            builder.column(entry.getKey(), entry.getValue().getLeft(), entry.getValue().getRight());
        }
        for (ComputedColumn computedColumn : computedColumns) {
            builder.column(computedColumn.columnName(), computedColumn.columnType());
        }
        if (specifiedPrimaryKeys.size() > 0) {
            for (String key : specifiedPrimaryKeys) {
                if (mySqlFields.containsKey(key) || !computedColumns.stream().noneMatch(c -> c.columnName().equals(key))) continue;
                throw new IllegalArgumentException("Specified primary key " + key + " does not exist in MySQL tables or computed columns.");
            }
            builder.primaryKey(specifiedPrimaryKeys);
        } else if (mySqlPrimaryKeys.size() > 0) {
            builder.primaryKey(mySqlPrimaryKeys);
        } else {
            throw new IllegalArgumentException("Primary keys are not specified. Also, can't infer primary keys from MySQL table schemas because MySQL tables have no primary keys or have different primary keys.");
        }
        if (specifiedPartitionKeys.size() > 0) {
            builder.partitionKeys(specifiedPartitionKeys);
        }
        return builder.build();
    }

    static MySqlSource<String> buildMySqlSource(Configuration mySqlConfig, String tableList) {
        MySqlActionUtils.validateMySqlConfig(mySqlConfig);
        MySqlSourceBuilder sourceBuilder = MySqlSource.builder();
        sourceBuilder.hostname((String)mySqlConfig.get(MySqlSourceOptions.HOSTNAME)).port(((Integer)mySqlConfig.get(MySqlSourceOptions.PORT)).intValue()).username((String)mySqlConfig.get(MySqlSourceOptions.USERNAME)).password((String)mySqlConfig.get(MySqlSourceOptions.PASSWORD)).databaseList(new String[]{(String)mySqlConfig.get(MySqlSourceOptions.DATABASE_NAME)}).tableList(new String[]{tableList});
        mySqlConfig.getOptional(MySqlSourceOptions.SERVER_ID).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).serverId(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.SERVER_TIME_ZONE).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).serverTimeZone(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).splitSize(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.CONNECT_TIMEOUT).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).connectTimeout(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.CONNECT_MAX_RETRIES).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).connectMaxRetries(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.CONNECTION_POOL_SIZE).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).connectionPoolSize(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.HEARTBEAT_INTERVAL).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).heartbeatInterval(arg_0));
        String startupMode = (String)mySqlConfig.get(MySqlSourceOptions.SCAN_STARTUP_MODE);
        if ("initial".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.initial());
        } else if ("earliest-offset".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.earliest());
        } else if ("latest-offset".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.latest());
        } else if ("specific-offset".equalsIgnoreCase(startupMode)) {
            BinlogOffsetBuilder offsetBuilder = BinlogOffset.builder();
            String file = (String)mySqlConfig.get(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_FILE);
            Long pos = (Long)mySqlConfig.get(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_POS);
            if (file != null && pos != null) {
                offsetBuilder.setBinlogFilePosition(file, pos.longValue());
            }
            mySqlConfig.getOptional(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_GTID_SET).ifPresent(arg_0 -> ((BinlogOffsetBuilder)offsetBuilder).setGtidSet(arg_0));
            mySqlConfig.getOptional(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_SKIP_EVENTS).ifPresent(arg_0 -> ((BinlogOffsetBuilder)offsetBuilder).setSkipEvents(arg_0));
            mySqlConfig.getOptional(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_SKIP_ROWS).ifPresent(arg_0 -> ((BinlogOffsetBuilder)offsetBuilder).setSkipRows(arg_0));
            sourceBuilder.startupOptions(StartupOptions.specificOffset((BinlogOffset)offsetBuilder.build()));
        } else if ("timestamp".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.timestamp((long)((Long)mySqlConfig.get(MySqlSourceOptions.SCAN_STARTUP_TIMESTAMP_MILLIS))));
        }
        Properties jdbcProperties = new Properties();
        Properties debeziumProperties = new Properties();
        for (Map.Entry entry : mySqlConfig.toMap().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("jdbc.properties.")) {
                jdbcProperties.put(key.substring("jdbc.properties.".length()), value);
                continue;
            }
            if (!key.startsWith("debezium.")) continue;
            debeziumProperties.put(key.substring("debezium.".length()), value);
        }
        sourceBuilder.jdbcProperties(jdbcProperties);
        sourceBuilder.debeziumProperties(debeziumProperties);
        HashMap<String, String> customConverterConfigs = new HashMap<String, String>();
        customConverterConfigs.put("decimal.format", "numeric");
        JsonDebeziumDeserializationSchema schema = new JsonDebeziumDeserializationSchema(Boolean.valueOf(true), customConverterConfigs);
        boolean scanNewlyAddedTables = (Boolean)mySqlConfig.get(SCAN_NEWLY_ADDED_TABLE_ENABLED);
        return sourceBuilder.deserializer((DebeziumDeserializationSchema)schema).includeSchemaChanges(true).scanNewlyAddedTableEnabled(scanNewlyAddedTables).build();
    }

    private static void validateMySqlConfig(Configuration mySqlConfig) {
        Preconditions.checkArgument(mySqlConfig.get(MySqlSourceOptions.HOSTNAME) != null, String.format("mysql-conf [%s] must be specified.", MySqlSourceOptions.HOSTNAME.key()));
        Preconditions.checkArgument(mySqlConfig.get(MySqlSourceOptions.USERNAME) != null, String.format("mysql-conf [%s] must be specified.", MySqlSourceOptions.USERNAME.key()));
        Preconditions.checkArgument(mySqlConfig.get(MySqlSourceOptions.PASSWORD) != null, String.format("mysql-conf [%s] must be specified.", MySqlSourceOptions.PASSWORD.key()));
        Preconditions.checkArgument(mySqlConfig.get(MySqlSourceOptions.DATABASE_NAME) != null, String.format("mysql-conf [%s] must be specified.", MySqlSourceOptions.DATABASE_NAME.key()));
    }
}

