/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.mysql.MySqlTypeUtils;
import org.apache.paimon.flink.sink.cdc.NewTableSchemaBuilder;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.Preconditions;

public class MySqlTableSchemaBuilder
implements NewTableSchemaBuilder<JsonNode> {
    private final Map<String, String> tableConfig;
    private final boolean caseSensitive;
    private final TypeMapping typeMapping;

    public MySqlTableSchemaBuilder(Map<String, String> tableConfig, boolean caseSensitive, TypeMapping typeMapping) {
        this.tableConfig = tableConfig;
        this.caseSensitive = caseSensitive;
        this.typeMapping = typeMapping;
    }

    @Override
    public Optional<Schema> build(JsonNode tableChange) {
        JsonNode jsonTable = tableChange.get("table");
        String tableName = tableChange.get("id").asText();
        ArrayNode columns = (ArrayNode)jsonTable.get("columns");
        LinkedHashMap<String, DataType> fields = new LinkedHashMap<String, DataType>();
        for (JsonNode element : columns) {
            JsonNode length = element.get("length");
            JsonNode scale = element.get("scale");
            DataType dataType = MySqlTypeUtils.toDataType(element.get("typeExpression").asText(), length == null ? null : Integer.valueOf(length.asInt()), scale == null ? null : Integer.valueOf(scale.asInt()), this.typeMapping);
            if (!this.typeMapping.containsMode(TypeMapping.TypeMappingMode.TO_NULLABLE)) {
                dataType.copy(element.get("optional").asBoolean());
            }
            fields.put(element.get("name").asText(), dataType);
        }
        ArrayNode arrayNode = (ArrayNode)jsonTable.get("primaryKeyColumnNames");
        List<String> primaryKeys = new ArrayList<String>();
        for (Iterator primary : arrayNode) {
            primaryKeys.add(((JsonNode)((Object)primary)).asText());
        }
        if (!this.caseSensitive) {
            LinkedHashMap tmp = new LinkedHashMap();
            for (Map.Entry entry : fields.entrySet()) {
                String fieldName = (String)entry.getKey();
                Preconditions.checkArgument(!tmp.containsKey(fieldName.toLowerCase()), "Duplicate key '%s' in table '%s' appears when converting fields map keys to case-insensitive form.", fieldName, tableName);
                tmp.put(fieldName.toLowerCase(), entry.getValue());
            }
            fields = tmp;
            primaryKeys = primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList());
        }
        Schema.Builder builder = Schema.newBuilder();
        builder.options(this.tableConfig);
        for (Map.Entry entry : fields.entrySet()) {
            builder.column((String)entry.getKey(), (DataType)entry.getValue());
        }
        Schema schema = builder.primaryKey(primaryKeys).build();
        return Optional.of(schema);
    }
}

