/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.mysql.schema.MySqlSchema;
import org.apache.paimon.flink.action.cdc.mysql.schema.MySqlTableInfo;
import org.apache.paimon.utils.Preconditions;

public class AllMergedMySqlTableInfo
implements MySqlTableInfo {
    private final List<Identifier> fromTables = new ArrayList<Identifier>();
    private MySqlSchema schema;

    public void init(Identifier identifier, MySqlSchema schema) {
        this.fromTables.add(identifier);
        this.schema = schema;
    }

    public AllMergedMySqlTableInfo merge(Identifier otherTableId, MySqlSchema other) {
        this.schema = this.schema.merge(this.location(), otherTableId.getFullName(), other);
        this.fromTables.add(otherTableId);
        return this;
    }

    @Override
    public String location() {
        return String.format("{%s}", this.fromTables.stream().map(Identifier::getFullName).collect(Collectors.joining(",")));
    }

    @Override
    public List<Identifier> identifiers() {
        throw new UnsupportedOperationException("AllMergedRichMySqlSchema doesn't support converting to identifiers.");
    }

    @Override
    public String tableName() {
        throw new UnsupportedOperationException("AllMergedRichMySqlSchema doesn't support getting table name.");
    }

    @Override
    public String toPaimonTableName() {
        throw new UnsupportedOperationException("AllMergedRichMySqlSchema doesn't support converting to Paimon table name.");
    }

    @Override
    public MySqlSchema schema() {
        return Preconditions.checkNotNull(this.schema, "MySqlSchema hasn't been set.");
    }
}

