/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.flink.sink.BucketsRowChannelComputer;
import org.apache.paimon.flink.sink.CompactorSink;
import org.apache.paimon.flink.sink.FlinkStreamPartitioner;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;

public class CompactorSinkBuilder {
    private final FileStoreTable table;
    private DataStream<RowData> input;

    public CompactorSinkBuilder(FileStoreTable table) {
        this.table = table;
    }

    public CompactorSinkBuilder withInput(DataStream<RowData> input) {
        this.input = input;
        return this;
    }

    public DataStreamSink<?> build() {
        BucketMode bucketMode = this.table.bucketMode();
        switch (bucketMode) {
            case FIXED: 
            case DYNAMIC: {
                return this.buildForBucketAware();
            }
        }
        throw new UnsupportedOperationException("Unsupported bucket mode: " + (Object)((Object)bucketMode));
    }

    private DataStreamSink<?> buildForBucketAware() {
        DataStream<RowData> partitioned = FlinkStreamPartitioner.partition(this.input, new BucketsRowChannelComputer(), null);
        return new CompactorSink(this.table).sinkFrom(partitioned);
    }
}

