/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.Serializable;
import java.util.UUID;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.sink.AdaptiveParallelism;
import org.apache.paimon.flink.sink.AutoTagForSavepointCommitterOperator;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.CommittableStateManager;
import org.apache.paimon.flink.sink.CommittableTypeInfo;
import org.apache.paimon.flink.sink.Committer;
import org.apache.paimon.flink.sink.CommitterOperator;
import org.apache.paimon.flink.sink.GlobalFullCompactionSinkWrite;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.flink.sink.StoreSinkWriteImpl;
import org.apache.paimon.flink.utils.StreamExecutionEnvironmentUtils;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;

public abstract class FlinkSink<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String WRITER_NAME = "Writer";
    private static final String WRITER_WRITE_ONLY_NAME = "Writer(write-only)";
    private static final String GLOBAL_COMMITTER_NAME = "Global Committer";
    protected final FileStoreTable table;
    private final boolean ignorePreviousFiles;

    public FlinkSink(FileStoreTable table, boolean ignorePreviousFiles) {
        this.table = table;
        this.ignorePreviousFiles = ignorePreviousFiles;
    }

    private StoreSinkWrite.Provider createWriteProvider(CheckpointConfig checkpointConfig, boolean isStreaming) {
        boolean waitCompaction;
        if (this.table.coreOptions().writeOnly()) {
            waitCompaction = false;
        } else {
            Options options = this.table.coreOptions().toConfiguration();
            CoreOptions.ChangelogProducer changelogProducer = this.table.coreOptions().changelogProducer();
            waitCompaction = changelogProducer == CoreOptions.ChangelogProducer.LOOKUP && options.get(FlinkConnectorOptions.CHANGELOG_PRODUCER_LOOKUP_WAIT) != false;
            int deltaCommits = -1;
            if (options.contains(CoreOptions.FULL_COMPACTION_DELTA_COMMITS)) {
                deltaCommits = options.get(CoreOptions.FULL_COMPACTION_DELTA_COMMITS);
            } else if (options.contains(FlinkConnectorOptions.CHANGELOG_PRODUCER_FULL_COMPACTION_TRIGGER_INTERVAL)) {
                long fullCompactionThresholdMs = options.get(FlinkConnectorOptions.CHANGELOG_PRODUCER_FULL_COMPACTION_TRIGGER_INTERVAL).toMillis();
                deltaCommits = (int)(fullCompactionThresholdMs / checkpointConfig.getCheckpointInterval());
            }
            if (changelogProducer == CoreOptions.ChangelogProducer.FULL_COMPACTION || deltaCommits >= 0) {
                int finalDeltaCommits = Math.max(deltaCommits, 1);
                return (table, commitUser, state, ioManager, memoryPool) -> new GlobalFullCompactionSinkWrite(table, commitUser, state, ioManager, this.ignorePreviousFiles, waitCompaction, finalDeltaCommits, isStreaming, memoryPool);
            }
        }
        return (table, commitUser, state, ioManager, memoryPool) -> new StoreSinkWriteImpl(table, commitUser, state, ioManager, this.ignorePreviousFiles, waitCompaction, isStreaming, memoryPool);
    }

    public DataStreamSink<?> sinkFrom(DataStream<T> input) {
        String initialCommitUser = UUID.randomUUID().toString();
        return this.sinkFrom(input, initialCommitUser);
    }

    public DataStreamSink<?> sinkFrom(DataStream<T> input, String initialCommitUser) {
        SingleOutputStreamOperator<Committable> written = this.doWrite(input, initialCommitUser, input.getParallelism());
        return this.doCommit((DataStream<Committable>)written, initialCommitUser);
    }

    public SingleOutputStreamOperator<Committable> doWrite(DataStream<T> input, String commitUser, Integer parallelism) {
        Options options;
        StreamExecutionEnvironment env = input.getExecutionEnvironment();
        boolean isStreaming = StreamExecutionEnvironmentUtils.getConfiguration(env).get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
        boolean writeOnly = this.table.coreOptions().writeOnly();
        SingleOutputStreamOperator written = input.transform((writeOnly ? WRITER_WRITE_ONLY_NAME : WRITER_NAME) + " : " + this.table.name(), (TypeInformation)new CommittableTypeInfo(), this.createWriteOperator(this.createWriteProvider(env.getCheckpointConfig(), isStreaming), commitUser)).setParallelism(parallelism == null ? input.getParallelism() : parallelism.intValue());
        if (!isStreaming) {
            this.assertBatchConfiguration(env, written.getParallelism());
        }
        if ((options = Options.fromMap(this.table.options())).get(FlinkConnectorOptions.SINK_USE_MANAGED_MEMORY).booleanValue()) {
            MemorySize memorySize = options.get(FlinkConnectorOptions.SINK_MANAGED_WRITER_BUFFER_MEMORY);
            written.getTransformation().declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, memorySize.getMebiBytes());
        }
        return written;
    }

    protected DataStreamSink<?> doCommit(DataStream<Committable> written, String commitUser) {
        boolean streamingCheckpointEnabled;
        StreamExecutionEnvironment env = written.getExecutionEnvironment();
        ReadableConfig conf = StreamExecutionEnvironmentUtils.getConfiguration(env);
        CheckpointConfig checkpointConfig = env.getCheckpointConfig();
        boolean isStreaming = conf.get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
        boolean bl = streamingCheckpointEnabled = isStreaming && checkpointConfig.isCheckpointingEnabled();
        if (streamingCheckpointEnabled) {
            FlinkSink.assertStreamingConfiguration(env);
        }
        BoundedOneInput committerOperator = new CommitterOperator<Committable, ManifestCommittable>(streamingCheckpointEnabled, commitUser, this.createCommitterFactory(streamingCheckpointEnabled), this.createCommittableStateManager());
        if (Options.fromMap(this.table.options()).get(FlinkConnectorOptions.SINK_AUTO_TAG_FOR_SAVEPOINT).booleanValue()) {
            committerOperator = new AutoTagForSavepointCommitterOperator<Committable, ManifestCommittable>((CommitterOperator<Committable, ManifestCommittable>)committerOperator, this.table::snapshotManager, this.table::tagManager);
        }
        SingleOutputStreamOperator committed = written.transform("Global Committer : " + this.table.name(), (TypeInformation)new CommittableTypeInfo(), committerOperator).setParallelism(1).setMaxParallelism(1);
        return committed.addSink((SinkFunction)new DiscardingSink()).name("end").setParallelism(1);
    }

    public static void assertStreamingConfiguration(StreamExecutionEnvironment env) {
        Preconditions.checkArgument(!env.getCheckpointConfig().isUnalignedCheckpointsEnabled(), "Paimon sink currently does not support unaligned checkpoints. Please set " + ExecutionCheckpointingOptions.ENABLE_UNALIGNED.key() + " to false.");
        Preconditions.checkArgument(env.getCheckpointConfig().getCheckpointingMode() == CheckpointingMode.EXACTLY_ONCE, "Paimon sink currently only supports EXACTLY_ONCE checkpoint mode. Please set " + ExecutionCheckpointingOptions.CHECKPOINTING_MODE.key() + " to exactly-once");
    }

    private void assertBatchConfiguration(StreamExecutionEnvironment env, int sinkParallelism) {
        try {
            Preconditions.checkArgument(sinkParallelism != -1 || !AdaptiveParallelism.isEnabled(env), "Paimon Sink does not support Flink's Adaptive Parallelism mode. Please manually turn it off or set Paimon `sink.parallelism` manually.");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    protected abstract OneInputStreamOperator<T, Committable> createWriteOperator(StoreSinkWrite.Provider var1, String var2);

    protected abstract Committer.Factory<Committable, ManifestCommittable> createCommitterFactory(boolean var1);

    protected abstract CommittableStateManager<ManifestCommittable> createCommittableStateManager();
}

