/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.RowLevelModificationScanContext;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsDeletePushDown;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelDelete;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelUpdate;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.types.logical.RowType;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.PredicateConverter;
import org.apache.paimon.flink.log.LogStoreTableFactory;
import org.apache.paimon.flink.sink.FlinkTableSinkBase;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.AllPrimaryKeyEqualVisitor;
import org.apache.paimon.predicate.OnlyPartitionKeyEqualVisitor;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.AppendOnlyFileStoreTable;
import org.apache.paimon.table.ChangelogValueCountFileStoreTable;
import org.apache.paimon.table.ChangelogWithKeyFileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.TableUtils;

public class FlinkTableSink
extends FlinkTableSinkBase
implements SupportsRowLevelUpdate,
SupportsRowLevelDelete,
SupportsDeletePushDown {
    @Nullable
    protected Predicate deletePredicate;

    public FlinkTableSink(ObjectIdentifier tableIdentifier, Table table, DynamicTableFactory.Context context, @Nullable LogStoreTableFactory logStoreTableFactory) {
        super(tableIdentifier, table, context, logStoreTableFactory);
    }

    @Override
    public DynamicTableSink copy() {
        FlinkTableSink copied = new FlinkTableSink(this.tableIdentifier, this.table, this.context, this.logStoreTableFactory);
        copied.staticPartitions = new HashMap(this.staticPartitions);
        copied.overwrite = this.overwrite;
        copied.deletePredicate = this.deletePredicate;
        return copied;
    }

    public SupportsRowLevelUpdate.RowLevelUpdateInfo applyRowLevelUpdate(List<Column> updatedColumns, @Nullable RowLevelModificationScanContext context) {
        if (this.table instanceof ChangelogWithKeyFileStoreTable) {
            Options options = Options.fromMap(this.table.options());
            HashSet<String> primaryKeys = new HashSet<String>(this.table.primaryKeys());
            updatedColumns.forEach(column -> {
                if (primaryKeys.contains(column.getName())) {
                    String errMsg = String.format("Updates to primary keys are not supported, primaryKeys (%s), updatedColumns (%s)", primaryKeys, updatedColumns.stream().map(Column::getName).collect(Collectors.toList()));
                    throw new UnsupportedOperationException(errMsg);
                }
            });
            if (options.get(CoreOptions.MERGE_ENGINE) == CoreOptions.MergeEngine.DEDUPLICATE || options.get(CoreOptions.MERGE_ENGINE) == CoreOptions.MergeEngine.PARTIAL_UPDATE) {
                return new SupportsRowLevelUpdate.RowLevelUpdateInfo(){};
            }
            throw new UnsupportedOperationException(String.format("%s can not support update, currently only %s of %s and %s can support update.", options.get(CoreOptions.MERGE_ENGINE), CoreOptions.MERGE_ENGINE.key(), CoreOptions.MergeEngine.DEDUPLICATE, CoreOptions.MergeEngine.PARTIAL_UPDATE));
        }
        if (this.table instanceof AppendOnlyFileStoreTable || this.table instanceof ChangelogValueCountFileStoreTable) {
            throw new UnsupportedOperationException(String.format("%s can not support update, because there is no primary key.", this.table.getClass().getName()));
        }
        throw new UnsupportedOperationException(String.format("%s can not support update, because it is an unknown subclass of FileStoreTable.", this.table.getClass().getName()));
    }

    public SupportsRowLevelDelete.RowLevelDeleteInfo applyRowLevelDelete(@Nullable RowLevelModificationScanContext rowLevelModificationScanContext) {
        this.validateDeletable();
        return new SupportsRowLevelDelete.RowLevelDeleteInfo(){};
    }

    public boolean applyDeleteFilters(List<ResolvedExpression> list) {
        this.validateDeletable();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        RowType rowType = LogicalTypeConversion.toLogicalType(this.table.rowType());
        for (ResolvedExpression filter : list) {
            Optional<Predicate> predicate = PredicateConverter.convert(rowType, filter);
            if (predicate.isPresent()) {
                predicates.add(predicate.get());
                continue;
            }
            return false;
        }
        this.deletePredicate = predicates.isEmpty() ? null : PredicateBuilder.and(predicates);
        return this.canPushDownDeleteFilter();
    }

    public Optional<Long> executeDeletion() {
        FileStoreCommit commit = ((AbstractFileStoreTable)this.table).store().newCommit(UUID.randomUUID().toString());
        long identifier = Long.MAX_VALUE;
        if (this.deletePredicate == null) {
            commit.purgeTable(identifier);
            return Optional.empty();
        }
        if (this.deleteIsDropPartition()) {
            commit.dropPartitions(Collections.singletonList(this.deletePartitions()), identifier);
            return Optional.empty();
        }
        return Optional.of(TableUtils.deleteWhere(this.table, Collections.singletonList(this.deletePredicate)));
    }

    private void validateDeletable() {
        if (this.table instanceof ChangelogWithKeyFileStoreTable) {
            Options options = Options.fromMap(this.table.options());
            if (options.get(CoreOptions.MERGE_ENGINE) == CoreOptions.MergeEngine.DEDUPLICATE) {
                return;
            }
            throw new UnsupportedOperationException(String.format("merge engine '%s' can not support delete, currently only %s can support delete.", options.get(CoreOptions.MERGE_ENGINE), CoreOptions.MergeEngine.DEDUPLICATE));
        }
        if (this.table instanceof ChangelogValueCountFileStoreTable) {
            return;
        }
        if (this.table instanceof AppendOnlyFileStoreTable) {
            throw new UnsupportedOperationException(String.format("table '%s' can not support delete, because there is no primary key.", this.table.getClass().getName()));
        }
        throw new UnsupportedOperationException(String.format("%s can not support delete, because it is an unknown subclass of FileStoreTable.", this.table.getClass().getName()));
    }

    private boolean canPushDownDeleteFilter() {
        return this.deletePredicate == null || this.deleteIsDropPartition() || this.deleteInSingleNode();
    }

    private boolean deleteIsDropPartition() {
        if (this.deletePredicate == null) {
            return false;
        }
        return this.deletePredicate.visit(new OnlyPartitionKeyEqualVisitor(this.table.partitionKeys()));
    }

    private Map<String, String> deletePartitions() {
        if (this.deletePredicate == null) {
            return null;
        }
        OnlyPartitionKeyEqualVisitor visitor = new OnlyPartitionKeyEqualVisitor(this.table.partitionKeys());
        this.deletePredicate.visit(visitor);
        return visitor.partitions();
    }

    private boolean deleteInSingleNode() {
        if (this.deletePredicate == null) {
            return false;
        }
        return this.deletePredicate.visit(new AllPrimaryKeyEqualVisitor(this.table.primaryKeys())).containsAll(this.table.primaryKeys());
    }
}

