/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.flink.table.data.RowData;
import org.apache.paimon.flink.sink.ChannelComputer;
import org.apache.paimon.flink.sink.RowDataPartitionKeyExtractor;
import org.apache.paimon.schema.TableSchema;

public class RowHashKeyChannelComputer
implements ChannelComputer<RowData> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private transient int numChannels;
    private transient RowDataPartitionKeyExtractor extractor;

    public RowHashKeyChannelComputer(TableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.extractor = new RowDataPartitionKeyExtractor(this.schema);
    }

    @Override
    public int channel(RowData record) {
        int hash = this.extractor.trimmedPrimaryKey(record).hashCode();
        return Math.abs(hash % this.numChannels);
    }

    public String toString() {
        return "shuffle by key hash";
    }
}

