/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.serializer.VersionedSerializer;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestCommittableSerializer;
import org.apache.paimon.manifest.WrappedManifestCommittable;

public class WrappedManifestCommittableSerializer
implements VersionedSerializer<WrappedManifestCommittable> {
    protected static final int CURRENT_VERSION = 1;
    private final ManifestCommittableSerializer manifestCommittableSerializer = new ManifestCommittableSerializer();

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public byte[] serialize(WrappedManifestCommittable wrapped) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(out);
        Map<Identifier, ManifestCommittable> map = wrapped.getManifestCommittables();
        view.writeInt(map.size());
        for (Map.Entry<Identifier, ManifestCommittable> entry : map.entrySet()) {
            byte[] serializedKey = entry.getKey().getFullName().getBytes(StandardCharsets.UTF_8);
            byte[] serializedValue = this.manifestCommittableSerializer.serialize(entry.getValue());
            view.writeInt(serializedKey.length);
            view.write(serializedKey);
            view.writeInt(serializedValue.length);
            view.write(serializedValue);
        }
        return out.toByteArray();
    }

    @Override
    public WrappedManifestCommittable deserialize(int version, byte[] serialized) throws IOException {
        if (version != 1) {
            throw new UnsupportedOperationException("Expecting WrappedManifestCommittable version to be 1, but found " + version + ".\nWrappedManifestCommittable is not a compatible data structure. Please restart the job afresh (do not recover from savepoint).");
        }
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        int mapSize = view.readInt();
        WrappedManifestCommittable wrappedManifestCommittable = new WrappedManifestCommittable();
        for (int i = 0; i < mapSize; ++i) {
            int keyLength = view.readInt();
            byte[] serializedKey = new byte[keyLength];
            view.read(serializedKey);
            Identifier key = Identifier.fromString(new String(serializedKey, StandardCharsets.UTF_8));
            int valueLength = view.readInt();
            byte[] serializedValue = new byte[valueLength];
            view.read(serializedValue);
            ManifestCommittable value = this.manifestCommittableSerializer.deserialize(this.manifestCommittableSerializer.getVersion(), serializedValue);
            wrappedManifestCommittable.putManifestCommittable(key, value);
        }
        return wrappedManifestCommittable;
    }

    private Map<Integer, Long> deserializeOffsets(DataInputDeserializer view) throws IOException {
        int size = view.readInt();
        HashMap<Integer, Long> offsets = new HashMap<Integer, Long>(size);
        for (int i = 0; i < size; ++i) {
            offsets.put(view.readInt(), view.readLong());
        }
        return offsets;
    }
}

