/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.index;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.EnumTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.ChannelComputer;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.FlinkStreamPartitioner;
import org.apache.paimon.flink.sink.FlinkWriteSink;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.flink.sink.cdc.CdcDynamicBucketWriteOperator;
import org.apache.paimon.flink.sink.cdc.CdcHashKeyChannelComputer;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecordUtils;
import org.apache.paimon.flink.sink.cdc.CdcWithBucketChannelComputer;
import org.apache.paimon.flink.sink.index.GlobalIndexAssignerOperator;
import org.apache.paimon.flink.sink.index.IndexBootstrap;
import org.apache.paimon.flink.sink.index.IndexBootstrapOperator;
import org.apache.paimon.flink.sink.index.KeyPartOrRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public class GlobalDynamicCdcBucketSink
extends FlinkWriteSink<Tuple2<CdcRecord, Integer>> {
    private static final long serialVersionUID = 1L;

    public GlobalDynamicCdcBucketSink(FileStoreTable table) {
        super(table, null);
    }

    @Override
    protected OneInputStreamOperator<Tuple2<CdcRecord, Integer>, Committable> createWriteOperator(StoreSinkWrite.Provider writeProvider, String commitUser) {
        return new CdcDynamicBucketWriteOperator(this.table, writeProvider, commitUser);
    }

    public DataStreamSink<?> build(DataStream<CdcRecord> input, @Nullable Integer parallelism) {
        String initialCommitUser = UUID.randomUUID().toString();
        TableSchema schema = this.table.schema();
        List<String> primaryKeys = schema.primaryKeys();
        List<String> partitionKeys = schema.partitionKeys();
        RowType keyPartType = schema.projectedLogicalRowType(Stream.concat(primaryKeys.stream(), partitionKeys.stream()).collect(Collectors.toList()));
        List<String> keyPartNames = keyPartType.getFieldNames();
        RowDataToObjectArrayConverter keyPartConverter = new RowDataToObjectArrayConverter(keyPartType);
        TupleTypeInfo tuple2TupleType = new TupleTypeInfo(new TypeInformation[]{new EnumTypeInfo(KeyPartOrRow.class), input.getType()});
        SingleOutputStreamOperator bootstraped = input.transform("INDEX_BOOTSTRAP", (TypeInformation)tuple2TupleType, new IndexBootstrapOperator(new IndexBootstrap(this.table), row -> CdcRecordUtils.fromGenericRow(GenericRow.ofKind(row.getRowKind(), keyPartConverter.convert((InternalRow)row)), keyPartNames))).setParallelism(input.getParallelism());
        Integer assignerParallelism = this.table.coreOptions().dynamicBucketAssignerParallelism();
        if (assignerParallelism == null) {
            assignerParallelism = parallelism;
        }
        ChannelComputer channelComputer = ChannelComputer.transform(new CdcHashKeyChannelComputer(schema), tuple2 -> (CdcRecord)tuple2.f1);
        DataStream partitionByKeyHash = FlinkStreamPartitioner.partition(bootstraped, channelComputer, assignerParallelism);
        TupleTypeInfo rowWithBucketType = new TupleTypeInfo(new TypeInformation[]{input.getType(), BasicTypeInfo.INT_TYPE_INFO});
        SingleOutputStreamOperator bucketAssigned = partitionByKeyHash.transform("dynamic-bucket-assigner", (TypeInformation)rowWithBucketType, GlobalIndexAssignerOperator.forCdcRecord(this.table)).setParallelism(partitionByKeyHash.getParallelism());
        DataStream<Tuple2<CdcRecord, Integer>> partitionByBucket = FlinkStreamPartitioner.partition(bucketAssigned, new CdcWithBucketChannelComputer(schema), parallelism);
        return this.sinkFrom(partitionByBucket, initialCommitUser);
    }
}

