/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.index;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.AbstractInnerTableScan;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.RowType;

public class IndexBootstrap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Table table;

    public IndexBootstrap(Table table) {
        this.table = table;
    }

    public void bootstrap(int numAssigners, int assignId, Consumer<InternalRow> collector) throws IOException {
        RowType rowType = this.table.rowType();
        List<String> fieldNames = rowType.getFieldNames();
        List keyPartFields = Stream.concat(this.table.primaryKeys().stream(), this.table.partitionKeys().stream()).collect(Collectors.toList());
        int[] projection = keyPartFields.stream().map(fieldNames::indexOf).mapToInt(Integer::intValue).toArray();
        ReadBuilder readBuilder = this.table.newReadBuilder().withProjection(projection);
        AbstractInnerTableScan tableScan = (AbstractInnerTableScan)readBuilder.newScan();
        TableScan.Plan plan = tableScan.withBucketFilter(bucket -> bucket % numAssigners == assignId).plan();
        try (RecordReader<InternalRow> reader = readBuilder.newRead().createReader(plan);){
            reader.forEachRemaining(collector);
        }
    }
}

