/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sorter;

import java.util.List;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.flink.sorter.TableSorter;
import org.apache.paimon.flink.sorter.ZorderSorterUtils;
import org.apache.paimon.sort.zorder.ZIndexer;
import org.apache.paimon.table.FileStoreTable;

public class ZorderSorter
extends TableSorter {
    public ZorderSorter(StreamExecutionEnvironment batchTEnv, DataStream<RowData> origin, FileStoreTable table, List<String> zOrderColNames) {
        super(batchTEnv, origin, table, zOrderColNames);
    }

    @Override
    public DataStream<RowData> sort() {
        return this.sortStreamByZOrder((DataStream<RowData>)this.origin, this.table);
    }

    private DataStream<RowData> sortStreamByZOrder(DataStream<RowData> inputStream, FileStoreTable table) {
        ZIndexer zIndexer = new ZIndexer(table.rowType(), this.orderColNames);
        return ZorderSorterUtils.sortStreamByZorder(inputStream, zIndexer, table);
    }
}

