/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.operator;

import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManagerImpl;
import org.apache.paimon.flink.FlinkRowData;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.utils.CloseableIterator;

public class ReadOperator
extends AbstractStreamOperator<RowData>
implements OneInputStreamOperator<Split, RowData> {
    private static final long serialVersionUID = 1L;
    private final ReadBuilder readBuilder;
    private transient TableRead read;
    private transient StreamRecord<RowData> reuseRecord;
    private transient FlinkRowData reuseRow;

    public ReadOperator(ReadBuilder readBuilder) {
        this.readBuilder = readBuilder;
    }

    public void open() throws Exception {
        super.open();
        IOManagerImpl ioManager = new IOManagerImpl(this.getContainingTask().getEnvironment().getIOManager().getSpillingDirectoriesPaths());
        this.read = this.readBuilder.newRead().withIOManager(ioManager);
        this.reuseRow = new FlinkRowData(null);
        this.reuseRecord = new StreamRecord((Object)this.reuseRow);
    }

    public void processElement(StreamRecord<Split> record) throws Exception {
        try (CloseableIterator<InternalRow> iterator = this.read.createReader((Split)record.getValue()).toCloseableIterator();){
            while (iterator.hasNext()) {
                this.reuseRow.replace((InternalRow)iterator.next());
                this.output.collect(this.reuseRecord);
            }
        }
    }
}

