/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public class TableEnvironmentUtils {
    public static void executeInternal(StreamTableEnvironment tEnv, List<Transformation<?>> transformations, List<String> sinkIdentifierNames) {
        Class<?> clazz = tEnv.getClass().getSuperclass().getSuperclass();
        try {
            Method executeInternal = clazz.getDeclaredMethod("executeInternal", List.class, List.class);
            executeInternal.setAccessible(true);
            TableResult tableResult = (TableResult)executeInternal.invoke((Object)tEnv, transformations, sinkIdentifierNames);
            tableResult.await();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to get 'TableEnvironmentImpl#executeInternal(List, List)' method from given StreamTableEnvironment instance by Java reflection. This is unexpected.", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke 'TableEnvironmentImpl#executeInternal(List, List)' method from given StreamTableEnvironment instance by Java reflection. This is unexpected.", e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to wait for insert job to finish.", e);
        }
    }
}

