/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.util.HashMap;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.table.Table;

public class TableScanUtils {
    public static void streamingReadingValidate(Table table) {
        CoreOptions options = CoreOptions.fromMap(table.options());
        CoreOptions.MergeEngine mergeEngine = options.mergeEngine();
        HashMap<CoreOptions.MergeEngine, String> mergeEngineDesc = new HashMap<CoreOptions.MergeEngine, String>(){
            {
                this.put(CoreOptions.MergeEngine.PARTIAL_UPDATE, "Partial update");
                this.put(CoreOptions.MergeEngine.AGGREGATE, "Pre-aggregate");
                this.put(CoreOptions.MergeEngine.FIRST_ROW, "First row");
            }
        };
        if (table.primaryKeys().size() > 0 && mergeEngineDesc.containsKey(mergeEngine)) {
            switch (options.changelogProducer()) {
                case NONE: 
                case INPUT: {
                    throw new RuntimeException((String)mergeEngineDesc.get(mergeEngine) + " streaming reading is not supported. You can use 'lookup' or 'full-compaction' changelog producer to support streaming reading.");
                }
            }
        }
    }
}

