/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.io.IOException;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.avro.FieldWriterFactory;
import org.apache.paimon.shade.org.apache.avro.Schema;
import org.apache.paimon.shade.org.apache.avro.io.DatumWriter;
import org.apache.paimon.shade.org.apache.avro.io.Encoder;
import org.apache.paimon.types.RowType;

public class AvroRowDatumWriter
implements DatumWriter<InternalRow> {
    private final RowType rowType;
    private FieldWriterFactory.RowWriter writer;
    private boolean isUnion;

    public AvroRowDatumWriter(RowType rowType) {
        this.rowType = rowType;
    }

    @Override
    public void setSchema(Schema schema) {
        this.isUnion = false;
        if (schema.isUnion()) {
            this.isUnion = true;
            schema = schema.getTypes().get(1);
        }
        this.writer = new FieldWriterFactory().createRowWriter(schema, this.rowType.getFieldTypes());
    }

    @Override
    public void write(InternalRow datum, Encoder out) throws IOException {
        if (this.isUnion) {
            out.writeIndex(1);
        }
        this.writer.writeRow(datum, out);
    }
}

