/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.util.List;
import org.apache.paimon.shade.org.apache.avro.LogicalType;
import org.apache.paimon.shade.org.apache.avro.LogicalTypes;
import org.apache.paimon.shade.org.apache.avro.Schema;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;

public interface AvroSchemaVisitor<T> {
    default public T visit(Schema schema, DataType type) {
        switch (schema.getType()) {
            case RECORD: {
                return this.visitRecord(schema, ((RowType)type).getFieldTypes());
            }
            case UNION: {
                return this.visitUnion(schema, type);
            }
            case ARRAY: {
                return this.visitArray(schema, ((ArrayType)type).getElementType());
            }
            case MAP: {
                DataType valueType = DataTypes.INT();
                if (type instanceof MapType) {
                    valueType = ((MapType)type).getValueType();
                }
                return this.visitMap(schema, valueType);
            }
        }
        return this.primitive(schema, type);
    }

    default public T primitive(Schema primitive, DataType type) {
        LogicalType logicalType = primitive.getLogicalType();
        if (logicalType != null) {
            switch (logicalType.getName()) {
                case "date": 
                case "time-millis": {
                    return this.visitInt();
                }
                case "timestamp-millis": {
                    return this.visitTimestampMillis(DataTypeChecks.getPrecision(type));
                }
                case "timestamp-micros": {
                    return this.visitTimestampMicros(DataTypeChecks.getPrecision(type));
                }
                case "decimal": {
                    LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                    return this.visitDecimal(decimal.getPrecision(), decimal.getScale());
                }
            }
            throw new IllegalArgumentException("Unknown logical type: " + logicalType);
        }
        switch (primitive.getType()) {
            case BOOLEAN: {
                return this.visitBoolean();
            }
            case INT: {
                switch (type.getTypeRoot()) {
                    case TINYINT: {
                        return this.visitTinyInt();
                    }
                    case SMALLINT: {
                        return this.visitSmallInt();
                    }
                }
                return this.visitInt();
            }
            case LONG: {
                return this.visitBigInt();
            }
            case FLOAT: {
                return this.visitFloat();
            }
            case DOUBLE: {
                return this.visitDouble();
            }
            case STRING: {
                return this.visitString();
            }
            case BYTES: {
                return this.visitBytes();
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + primitive);
    }

    public T visitUnion(Schema var1, DataType var2);

    public T visitString();

    public T visitBytes();

    public T visitInt();

    public T visitTinyInt();

    public T visitSmallInt();

    public T visitBoolean();

    public T visitBigInt();

    public T visitFloat();

    public T visitDouble();

    public T visitTimestampMillis(int var1);

    public T visitTimestampMicros(int var1);

    public T visitDecimal(int var1, int var2);

    public T visitArray(Schema var1, DataType var2);

    public T visitMap(Schema var1, DataType var2);

    public T visitRecord(Schema var1, List<DataType> var2);
}

