/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.writer;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.AccessController;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.orc.writer.Vectorizer;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.shade.org.apache.orc.Writer;
import org.apache.paimon.shade.org.apache.orc.impl.writer.TreeWriter;
import org.apache.paimon.utils.Preconditions;

public class OrcBulkWriter
implements FormatWriter {
    private final Writer writer;
    private final Vectorizer<InternalRow> vectorizer;
    private final VectorizedRowBatch rowBatch;
    private final PositionOutputStream underlyingStream;
    private final TreeWriter treeWriter;

    public OrcBulkWriter(Vectorizer<InternalRow> vectorizer, Writer writer, PositionOutputStream underlyingStream, int batchSize) {
        this.vectorizer = Preconditions.checkNotNull(vectorizer);
        this.writer = Preconditions.checkNotNull(writer);
        this.rowBatch = vectorizer.getSchema().createRowBatch(batchSize);
        this.vectorizer.setWriter(this.writer);
        this.underlyingStream = underlyingStream;
        this.treeWriter = (TreeWriter)this.getHiddenFieldInORC("treeWriter");
    }

    @Override
    public void addElement(InternalRow element) throws IOException {
        this.vectorizer.vectorize(element, this.rowBatch);
        if (this.rowBatch.size == this.rowBatch.getMaxSize()) {
            this.writer.addRowBatch(this.rowBatch);
            this.rowBatch.reset();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.rowBatch.size != 0) {
            this.writer.addRowBatch(this.rowBatch);
            this.rowBatch.reset();
        }
    }

    @Override
    public void finish() throws IOException {
        this.flush();
        this.writer.close();
    }

    @Override
    public boolean reachTargetSize(boolean suggestedCheck, long targetSize) throws IOException {
        return this.rowBatch.size == 0 && this.length() >= targetSize;
    }

    private long length() throws IOException {
        long estimateMemory = this.treeWriter.estimateMemory();
        long fileLength = this.underlyingStream.getPos();
        return (long)Math.ceil((double)fileLength + (double)estimateMemory * 0.2);
    }

    private <T> T getHiddenFieldInORC(String fieldName) {
        try {
            Field treeWriterField = this.writer.getClass().getDeclaredField(fieldName);
            AccessController.doPrivileged(() -> {
                treeWriterField.setAccessible(true);
                return null;
            });
            return (T)treeWriterField.get(this.writer);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get " + fieldName + " from " + this.writer.getClass().getName(), e);
        }
    }

    @VisibleForTesting
    VectorizedRowBatch getRowBatch() {
        return this.rowBatch;
    }
}

