/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveCatalog;
import org.apache.paimon.hive.HiveCatalogOptions;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalogFactory
implements CatalogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalogFactory.class);
    private static final ConfigOption<String> METASTORE_CLIENT_CLASS = ConfigOptions.key("metastore.client.class").stringType().defaultValue("org.apache.hadoop.hive.metastore.HiveMetaStoreClient").withDescription("Class name of Hive metastore client.\nNOTE: This class must directly implements org.apache.hadoop.hive.metastore.IMetaStoreClient.");

    @Override
    public String identifier() {
        return "hive";
    }

    @Override
    public Catalog create(FileIO fileIO, Path warehouse, CatalogContext context) {
        String uri = context.options().get(CatalogOptions.URI);
        String hiveConfDir = context.options().get(HiveCatalogOptions.HIVE_CONF_DIR);
        String hadoopConfDir = context.options().get(HiveCatalogOptions.HADOOP_CONF_DIR);
        HiveConf hiveConf = HiveCatalog.createHiveConf(hiveConfDir, hadoopConfDir);
        context.options().toMap().forEach((arg_0, arg_1) -> ((HiveConf)hiveConf).set(arg_0, arg_1));
        if (uri != null) {
            hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, uri);
        }
        if (hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname) == null) {
            LOG.error("Can't find hive metastore uri to connect:  either set " + CatalogOptions.URI.key() + " for paimon " + "hive" + " catalog or set hive.metastore.uris in hive-site.xml or hadoop configurations. Will use empty metastore uris, which means we may use a embedded metastore. The may cause unpredictable consensus problem.");
        }
        String clientClassName = context.options().get(METASTORE_CLIENT_CLASS);
        return new HiveCatalog(fileIO, hiveConf, clientClassName, context.options().toMap(), warehouse.toUri().toString());
    }
}

