/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntPredicate;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.utils.Int2ShortHashMap;
import org.apache.paimon.utils.IntIterator;

public class PartitionIndex {
    public final Int2ShortHashMap hash2Bucket;
    public final Map<Integer, Long> bucketInformation;
    private final long targetBucketRowNumber;
    public boolean accessed;
    public long lastAccessedCommitIdentifier;

    public PartitionIndex(Int2ShortHashMap hash2Bucket, Map<Integer, Long> bucketInformation, long targetBucketRowNumber) {
        this.hash2Bucket = hash2Bucket;
        this.bucketInformation = bucketInformation;
        this.targetBucketRowNumber = targetBucketRowNumber;
        this.lastAccessedCommitIdentifier = Long.MIN_VALUE;
        this.accessed = true;
    }

    public int assign(int hash, IntPredicate bucketFilter) {
        this.accessed = true;
        if (this.hash2Bucket.containsKey(hash)) {
            return this.hash2Bucket.get(hash);
        }
        for (Integer bucket : this.bucketInformation.keySet()) {
            Long number;
            if (!bucketFilter.test(bucket) || (number = this.bucketInformation.get(bucket)) >= this.targetBucketRowNumber) continue;
            this.bucketInformation.put(bucket, number + 1L);
            this.hash2Bucket.put(hash, bucket.shortValue());
            return bucket;
        }
        for (int i = 0; i < Short.MAX_VALUE; ++i) {
            if (!bucketFilter.test(i) || this.bucketInformation.containsKey(i)) continue;
            this.hash2Bucket.put(hash, (short)i);
            this.bucketInformation.put(i, 1L);
            return i;
        }
        int maxBucket = this.bucketInformation.keySet().stream().mapToInt(Integer::intValue).max().getAsInt();
        throw new RuntimeException(String.format("To more bucket %s, you should increase target bucket row number %s.", maxBucket, this.targetBucketRowNumber));
    }

    public static PartitionIndex loadIndex(IndexFileHandler indexFileHandler, BinaryRow partition, long targetBucketRowNumber, IntPredicate loadFilter) {
        Int2ShortHashMap map = new Int2ShortHashMap();
        List<IndexManifestEntry> files = indexFileHandler.scan("HASH", partition);
        HashMap<Integer, Long> buckets = new HashMap<Integer, Long>();
        for (IndexManifestEntry file : files) {
            try {
                IntIterator iterator = indexFileHandler.readHashIndex(file.indexFile());
                Throwable throwable = null;
                try {
                    try {
                        while (true) {
                            int hash;
                            if (loadFilter.test(hash = iterator.next())) {
                                map.put(hash, (short)file.bucket());
                            }
                            buckets.compute(file.bucket(), (bucket, number) -> number == null ? 1L : number + 1L);
                        }
                    }
                    catch (EOFException ignored) {
                        if (iterator == null) continue;
                        if (throwable != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        iterator.close();
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (iterator != null) {
                            if (throwable != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw throwable4;
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new PartitionIndex(map, buckets, targetBucketRowNumber);
    }
}

