/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.fs.Path;

@ThreadSafe
public class DataFilePathFactory {
    public static final String DATA_FILE_PREFIX = "data-";
    public static final String CHANGELOG_FILE_PREFIX = "changelog-";
    private final Path bucketDir;
    private final String uuid;
    private final AtomicInteger pathCount;
    private final String formatIdentifier;

    public DataFilePathFactory(Path root, String partition, int bucket, String formatIdentifier) {
        this.bucketDir = DataFilePathFactory.bucketPath(root, partition, bucket);
        this.uuid = UUID.randomUUID().toString();
        this.pathCount = new AtomicInteger(0);
        this.formatIdentifier = formatIdentifier;
    }

    public Path newPath() {
        return this.newPath(DATA_FILE_PREFIX);
    }

    public Path newChangelogPath() {
        return this.newPath(CHANGELOG_FILE_PREFIX);
    }

    private Path newPath(String prefix) {
        String name = prefix + this.uuid + "-" + this.pathCount.getAndIncrement() + "." + this.formatIdentifier;
        return new Path(this.bucketDir, name);
    }

    public Path toPath(String fileName) {
        return new Path(this.bucketDir + "/" + fileName);
    }

    @VisibleForTesting
    public String uuid() {
        return this.uuid;
    }

    public static Path bucketPath(Path tablePath, String partition, int bucket) {
        return new Path(tablePath + "/" + partition + "/bucket-" + bucket);
    }

    public static String formatIdentifier(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException(fileName + " is not a legal file name.");
        }
        return fileName.substring(index + 1);
    }
}

