/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatKey;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.KeyValueDataFileRecordReader;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BulkFormatMapping;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Projection;

public class KeyValueFileReaderFactory {
    private final FileIO fileIO;
    private final SchemaManager schemaManager;
    private final long schemaId;
    private final RowType keyType;
    private final RowType valueType;
    private final BulkFormatMapping.BulkFormatMappingBuilder bulkFormatMappingBuilder;
    private final Map<FormatKey, BulkFormatMapping> bulkFormatMappings;
    private final DataFilePathFactory pathFactory;

    private KeyValueFileReaderFactory(FileIO fileIO, SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, BulkFormatMapping.BulkFormatMappingBuilder bulkFormatMappingBuilder, DataFilePathFactory pathFactory) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schemaId = schemaId;
        this.keyType = keyType;
        this.valueType = valueType;
        this.bulkFormatMappingBuilder = bulkFormatMappingBuilder;
        this.pathFactory = pathFactory;
        this.bulkFormatMappings = new HashMap<FormatKey, BulkFormatMapping>();
    }

    public RecordReader<KeyValue> createRecordReader(long schemaId, String fileName, int level) throws IOException {
        String formatIdentifier = DataFilePathFactory.formatIdentifier(fileName);
        BulkFormatMapping bulkFormatMapping = this.bulkFormatMappings.computeIfAbsent(new FormatKey(schemaId, formatIdentifier), key -> {
            TableSchema tableSchema = this.schemaManager.schema(this.schemaId);
            TableSchema dataSchema = this.schemaManager.schema(key.schemaId);
            return this.bulkFormatMappingBuilder.build(formatIdentifier, tableSchema, dataSchema);
        });
        return new KeyValueDataFileRecordReader(this.fileIO, bulkFormatMapping.getReaderFactory(), this.pathFactory.toPath(fileName), this.keyType, this.valueType, level, bulkFormatMapping.getIndexMapping(), bulkFormatMapping.getCastMapping());
    }

    public static Builder builder(FileIO fileIO, SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor) {
        return new Builder(fileIO, schemaManager, schemaId, keyType, valueType, formatDiscover, pathFactory, extractor);
    }

    public static class Builder {
        private final FileIO fileIO;
        private final SchemaManager schemaManager;
        private final long schemaId;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormatDiscover formatDiscover;
        private final FileStorePathFactory pathFactory;
        private final KeyValueFieldsExtractor extractor;
        private final int[][] fullKeyProjection;
        private int[][] keyProjection;
        private int[][] valueProjection;
        private RowType projectedKeyType;
        private RowType projectedValueType;

        private Builder(FileIO fileIO, SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor) {
            this.fileIO = fileIO;
            this.schemaManager = schemaManager;
            this.schemaId = schemaId;
            this.keyType = keyType;
            this.valueType = valueType;
            this.formatDiscover = formatDiscover;
            this.pathFactory = pathFactory;
            this.extractor = extractor;
            this.fullKeyProjection = Projection.range(0, keyType.getFieldCount()).toNestedIndexes();
            this.keyProjection = this.fullKeyProjection;
            this.valueProjection = Projection.range(0, valueType.getFieldCount()).toNestedIndexes();
            this.applyProjection();
        }

        public Builder copyWithoutProjection() {
            return new Builder(this.fileIO, this.schemaManager, this.schemaId, this.keyType, this.valueType, this.formatDiscover, this.pathFactory, this.extractor);
        }

        public Builder withKeyProjection(int[][] projection) {
            this.keyProjection = projection;
            this.applyProjection();
            return this;
        }

        public Builder withValueProjection(int[][] projection) {
            this.valueProjection = projection;
            this.applyProjection();
            return this;
        }

        public RowType projectedValueType() {
            return this.projectedValueType;
        }

        public KeyValueFileReaderFactory build(BinaryRow partition, int bucket) {
            return this.build(partition, bucket, true, Collections.emptyList());
        }

        public KeyValueFileReaderFactory build(BinaryRow partition, int bucket, boolean projectKeys, @Nullable List<Predicate> filters) {
            int[][] keyProjection = projectKeys ? this.keyProjection : this.fullKeyProjection;
            RowType projectedKeyType = projectKeys ? this.projectedKeyType : this.keyType;
            return new KeyValueFileReaderFactory(this.fileIO, this.schemaManager, this.schemaId, projectedKeyType, this.projectedValueType, BulkFormatMapping.newBuilder(this.formatDiscover, this.extractor, keyProjection, this.valueProjection, filters), this.pathFactory.createDataFilePathFactory(partition, bucket));
        }

        private void applyProjection() {
            this.projectedKeyType = Projection.of(this.keyProjection).project(this.keyType);
            this.projectedValueType = Projection.of(this.valueProjection).project(this.valueType);
        }
    }
}

