/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.manifest.ManifestCommittable;

public class WrappedManifestCommittable {
    private Map<Identifier, ManifestCommittable> manifestCommittables = new TreeMap<Identifier, ManifestCommittable>(Comparator.comparing(Identifier::getDatabaseName).thenComparing(Identifier::getObjectName));

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrappedManifestCommittable that = (WrappedManifestCommittable)o;
        if (this.manifestCommittables.size() != that.manifestCommittables.size()) {
            return false;
        }
        for (Map.Entry<Identifier, ManifestCommittable> entry : this.manifestCommittables.entrySet()) {
            if (Objects.equals(entry.getValue(), that.manifestCommittables.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.manifestCommittables.values().toArray(new Object[0]));
    }

    public String toString() {
        return String.format("WrappedManifestCommittable {manifestCommittables = %s", this.formatManifestCommittables());
    }

    private String formatManifestCommittables() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Identifier id : this.manifestCommittables.keySet()) {
            ManifestCommittable committable = this.manifestCommittables.get(id);
            sb.append(String.format("%s=%s, ", id.getFullName(), committable.toString()));
        }
        if (this.manifestCommittables.size() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}");
        return sb.toString();
    }

    public ManifestCommittable computeCommittableIfAbsent(Identifier identifier, long checkpointId, long watermark) {
        return this.manifestCommittables.computeIfAbsent(identifier, id -> new ManifestCommittable(checkpointId, watermark));
    }

    public ManifestCommittable putManifestCommittable(Identifier identifier, ManifestCommittable manifestCommittable) {
        return this.manifestCommittables.put(identifier, manifestCommittable);
    }

    public Map<Identifier, ManifestCommittable> getManifestCommittables() {
        return this.manifestCommittables;
    }
}

