/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.List;
import org.apache.paimon.KeyValue;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.mergetree.ContainsLevels;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ChangelogMergeTreeRewriter;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.FirstRowMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.Preconditions;

public class FirstRowMergeTreeCompactRewriter
extends ChangelogMergeTreeRewriter {
    private final ContainsLevels containsLevels;

    public FirstRowMergeTreeCompactRewriter(ContainsLevels containsLevels, KeyValueFileReaderFactory readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<InternalRow> keyComparator, MergeFunctionFactory<KeyValue> mfFactory, MergeSorter mergeSorter, RecordEqualiser valueEqualiser, boolean changelogRowDeduplicate) {
        super(readerFactory, writerFactory, keyComparator, mfFactory, mergeSorter, valueEqualiser, changelogRowDeduplicate);
        this.containsLevels = containsLevels;
    }

    @Override
    protected boolean rewriteChangelog(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) {
        return this.rewriteLookupChangelog(outputLevel, sections);
    }

    @Override
    protected boolean upgradeChangelog(int outputLevel, DataFileMeta file) {
        return file.level() == 0;
    }

    @Override
    protected MergeFunctionWrapper<ChangelogResult> createMergeWrapper(int outputLevel) {
        return new FistRowMergeFunctionWrapper(this.mfFactory, key -> {
            try {
                return this.containsLevels.contains((InternalRow)key, outputLevel + 1);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.containsLevels.close();
    }

    @VisibleForTesting
    static class FistRowMergeFunctionWrapper
    implements MergeFunctionWrapper<ChangelogResult> {
        private final Filter<InternalRow> contains;
        private final FirstRowMergeFunction mergeFunction;
        private final ChangelogResult reusedResult = new ChangelogResult();

        public FistRowMergeFunctionWrapper(MergeFunctionFactory<KeyValue> mergeFunctionFactory, Filter<InternalRow> contains) {
            this.contains = contains;
            MergeFunction<KeyValue> mergeFunction = mergeFunctionFactory.create();
            Preconditions.checkArgument(mergeFunction instanceof FirstRowMergeFunction, "Merge function should be a FirstRowMergeFunction, but is %s, there is a bug.", mergeFunction.getClass().getName());
            this.mergeFunction = (FirstRowMergeFunction)mergeFunction;
        }

        @Override
        public void reset() {
            this.mergeFunction.reset();
        }

        @Override
        public void add(KeyValue kv) {
            this.mergeFunction.add(kv);
        }

        @Override
        public ChangelogResult getResult() {
            this.reusedResult.reset();
            KeyValue result = this.mergeFunction.getResult();
            Preconditions.checkArgument(result != null);
            if (this.contains.test(result.key())) {
                return this.reusedResult;
            }
            this.reusedResult.setResult(result);
            if (result.level() == 0) {
                return this.reusedResult.addChangelog(result);
            }
            return this.reusedResult;
        }
    }
}

