/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileDeletionBase;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.TagManager;

public class SnapshotDeletion
extends FileDeletionBase {
    private int cachedTagIndex = -1;
    private final Map<BinaryRow, Map<Integer, Set<String>>> cachedTagDataFiles = new HashMap<BinaryRow, Map<Integer, Set<String>>>();

    public SnapshotDeletion(FileIO fileIO, FileStorePathFactory pathFactory, ManifestFile manifestFile, ManifestList manifestList, IndexFileHandler indexFileHandler) {
        super(fileIO, pathFactory, manifestFile, manifestList, indexFileHandler);
    }

    @Override
    public void cleanUnusedDataFiles(Snapshot snapshot, Predicate<ManifestEntry> skipper) {
        this.doCleanUnusedDataFile(this.tryReadManifestEntries(snapshot.deltaManifestList()), skipper);
    }

    @Override
    public void cleanUnusedManifests(Snapshot snapshot, Set<String> skippingSet) {
        this.cleanUnusedManifests(snapshot, skippingSet, true);
    }

    @VisibleForTesting
    void doCleanUnusedDataFile(Iterable<ManifestEntry> dataFileLog, Predicate<ManifestEntry> skipper) {
        HashMap<Path, Pair> dataFileToDelete = new HashMap<Path, Pair>();
        block4: for (ManifestEntry entry : dataFileLog) {
            Path bucketPath = this.pathFactory.bucketPath(entry.partition(), entry.bucket());
            Path dataFilePath = new Path(bucketPath, entry.file().fileName());
            switch (entry.kind()) {
                case ADD: {
                    dataFileToDelete.remove(dataFilePath);
                    continue block4;
                }
                case DELETE: {
                    ArrayList<Path> extraFiles = new ArrayList<Path>(entry.file().extraFiles().size());
                    for (String file : entry.file().extraFiles()) {
                        extraFiles.add(new Path(bucketPath, file));
                    }
                    dataFileToDelete.put(dataFilePath, Pair.of(entry, extraFiles));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown value kind " + entry.kind().name());
        }
        dataFileToDelete.forEach((path, pair) -> {
            ManifestEntry entry = (ManifestEntry)pair.getLeft();
            if (!skipper.test(entry)) {
                this.fileIO.deleteQuietly((Path)path);
                ((List)pair.getRight()).forEach(this.fileIO::deleteQuietly);
                this.recordDeletionBuckets(entry);
            }
        });
    }

    public void deleteAddedDataFiles(String manifestListName) {
        this.deleteAddedDataFiles(this.tryReadManifestEntries(manifestListName));
    }

    public void deleteAddedDataFiles(Iterable<ManifestEntry> manifestEntries) {
        for (ManifestEntry entry : manifestEntries) {
            if (entry.kind() != FileKind.ADD) continue;
            this.fileIO.deleteQuietly(new Path(this.pathFactory.bucketPath(entry.partition(), entry.bucket()), entry.file().fileName()));
            this.recordDeletionBuckets(entry);
        }
    }

    public Predicate<ManifestEntry> dataFileSkipper(List<Snapshot> taggedSnapshots, long expiringSnapshotId) {
        int index = TagManager.findPreviousTag(taggedSnapshots, expiringSnapshotId);
        if (index >= 0 && this.cachedTagIndex != index) {
            this.cachedTagIndex = index;
            this.cachedTagDataFiles.clear();
            this.addMergedDataFiles(this.cachedTagDataFiles, taggedSnapshots.get(index));
        }
        return entry -> index >= 0 && this.containsDataFile(this.cachedTagDataFiles, (ManifestEntry)entry);
    }
}

